/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.processors;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import java.util.Map;
import lombok.Generated;

public final class DetermineWebsocketRouteProcessor
implements Processor {
    private final String routeSelectionExpression;

    public static Processor determineWebsocketRouteProcessor(String routeSelectionExpression) {
        Validators.validateNotNull(routeSelectionExpression, "routeSelectionExpression");
        return new DetermineWebsocketRouteProcessor(routeSelectionExpression);
    }

    @Override
    public void apply(MetaData metaData) {
        metaData.getOptional(HttpMaidChainKeys.UNMARSHALLED_REQUEST_BODY).ifPresent(unmarshalledRequestBody -> {
            if (!(unmarshalledRequestBody instanceof Map)) {
                return;
            }
            Map map = (Map)unmarshalledRequestBody;
            if (!map.containsKey(this.routeSelectionExpression)) {
                return;
            }
            Object category = map.get(this.routeSelectionExpression);
            if (category instanceof String) {
                metaData.set(WebsocketMetaDataKeys.WEBSOCKET_ROUTE, (String)category);
            }
        });
    }

    @Generated
    public String toString() {
        return "DetermineWebsocketRouteProcessor(routeSelectionExpression=" + this.routeSelectionExpression + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetermineWebsocketRouteProcessor)) {
            return false;
        }
        DetermineWebsocketRouteProcessor other = (DetermineWebsocketRouteProcessor)o;
        String this$routeSelectionExpression = this.routeSelectionExpression;
        String other$routeSelectionExpression = other.routeSelectionExpression;
        return !(this$routeSelectionExpression == null ? other$routeSelectionExpression != null : !this$routeSelectionExpression.equals(other$routeSelectionExpression));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $routeSelectionExpression = this.routeSelectionExpression;
        result = result * 59 + ($routeSelectionExpression == null ? 43 : $routeSelectionExpression.hashCode());
        return result;
    }

    @Generated
    private DetermineWebsocketRouteProcessor(String routeSelectionExpression) {
        this.routeSelectionExpression = routeSelectionExpression;
    }
}

