/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.registry;

import de.quantummaid.httpmaid.http.Header;
import de.quantummaid.httpmaid.http.HeaderName;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class HeaderFilter {
    private final List<HeaderName> names;

    public static HeaderFilter allowListHeaderFilter(List<HeaderName> names) {
        List<HeaderName> allAllowedHeaders;
        NotNullValidator.validateNotNull(names, (String)"names");
        HeaderName contentTypeHeader = HeaderName.headerName("Content-Type");
        if (names.contains(contentTypeHeader)) {
            allAllowedHeaders = names;
        } else {
            allAllowedHeaders = new ArrayList<HeaderName>(names);
            allAllowedHeaders.add(contentTypeHeader);
        }
        return new HeaderFilter(allAllowedHeaders);
    }

    public List<Header> filter(List<Header> values) {
        return values.stream().filter((? super T header) -> {
            HeaderName name = header.name();
            return this.names.contains(name);
        }).collect(Collectors.toList());
    }

    @Generated
    private HeaderFilter(List<HeaderName> names) {
        this.names = names;
    }
}

