/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains.graph;

import de.quantummaid.httpmaid.chains.graph.Color;
import de.quantummaid.httpmaid.chains.graph.Label;
import de.quantummaid.httpmaid.chains.graph.Node;
import de.quantummaid.httpmaid.util.Validators;

public final class Edge {
    private final Node from;
    private final Node to;
    private final Color color;
    private final Label label;

    public static Edge edge(Node from, Node to) {
        return Edge.edge(from, to, Color.BLACK, Label.emptyLabel());
    }

    public static Edge edge(Node from, Node to, Color color, Label label) {
        Validators.validateNotNull(from, "from");
        Validators.validateNotNull(to, "to");
        Validators.validateNotNull(color, "color");
        Validators.validateNotNull(label, "label");
        return new Edge(from, to, color, label);
    }

    String plot() {
        return String.format("%s -> %s [color=\"%s\"; label=%s ];", this.from.name(), this.to.name(), this.color.color(), this.label.plot()) + "\n";
    }

    public String toString() {
        return "Edge(from=" + this.from + ", to=" + this.to + ", color=" + this.color + ", label=" + this.label + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge other = (Edge)o;
        Node this$from = this.from;
        Node other$from = other.from;
        if (this$from == null ? other$from != null : !((Object)this$from).equals(other$from)) {
            return false;
        }
        Node this$to = this.to;
        Node other$to = other.to;
        if (this$to == null ? other$to != null : !((Object)this$to).equals(other$to)) {
            return false;
        }
        Color this$color = this.color;
        Color other$color = other.color;
        if (this$color == null ? other$color != null : !((Object)this$color).equals(other$color)) {
            return false;
        }
        Label this$label = this.label;
        Label other$label = other.label;
        return !(this$label == null ? other$label != null : !((Object)this$label).equals(other$label));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Node $from = this.from;
        result = result * 59 + ($from == null ? 43 : ((Object)$from).hashCode());
        Node $to = this.to;
        result = result * 59 + ($to == null ? 43 : ((Object)$to).hashCode());
        Color $color = this.color;
        result = result * 59 + ($color == null ? 43 : ((Object)$color).hashCode());
        Label $label = this.label;
        result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
        return result;
    }

    private Edge(Node from, Node to, Color color, Label label) {
        this.from = from;
        this.to = to;
        this.color = color;
        this.label = label;
    }
}

