/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http.headers.cookies;

import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.headers.cookies.CookieName;
import de.quantummaid.httpmaid.http.headers.cookies.CookieValue;
import de.quantummaid.httpmaid.util.Maps;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public final class Cookies {
    private final Map<CookieName, CookieValue> cookies;

    public static Cookies cookiesFromHeaders(Headers headers) {
        HashMap<CookieName, CookieValue> cookies = new HashMap<CookieName, CookieValue>();
        headers.getOptionalHeader("Cookie").ifPresent(header -> {
            String[] keyValuePairs = header.split("; ");
            Arrays.stream(keyValuePairs).map(Cookies::parseKeyValuePair).forEach(entry -> cookies.put((CookieName)entry.getKey(), (CookieValue)entry.getValue()));
        });
        return new Cookies(cookies);
    }

    public Optional<String> getOptionalCookie(String name) {
        CookieName cookieName = CookieName.cookieName(name);
        return Maps.getOptionally(this.cookies, cookieName).map(CookieValue::stringValue);
    }

    public String getCookie(String name) {
        return this.getOptionalCookie(name).orElseThrow(() -> new RuntimeException(String.format("No cookie with name '%s'", name)));
    }

    private static Map.Entry<CookieName, CookieValue> parseKeyValuePair(String keyValuePair) {
        String[] tokens = keyValuePair.split("=");
        String value = tokens.length == 1 ? "" : tokens[1];
        String adjustedValue = value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
        String key = tokens[0];
        return new AbstractMap.SimpleEntry<CookieName, CookieValue>(CookieName.cookieName(key), CookieValue.cookieValue(adjustedValue));
    }

    public String toString() {
        return "Cookies(cookies=" + this.cookies + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cookies)) {
            return false;
        }
        Cookies other = (Cookies)o;
        Map<CookieName, CookieValue> this$cookies = this.cookies;
        Map<CookieName, CookieValue> other$cookies = other.cookies;
        return !(this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<CookieName, CookieValue> $cookies = this.cookies;
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        return result;
    }

    private Cookies(Map<CookieName, CookieValue> cookies) {
        this.cookies = cookies;
    }
}

