/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http.headers.cookies;

import de.quantummaid.httpmaid.http.headers.cookies.CookieName;
import de.quantummaid.httpmaid.http.headers.cookies.CookieValue;
import de.quantummaid.httpmaid.util.Validators;

public final class SetCookieHeader {
    private final CookieName name;
    private final CookieValue value;

    public static SetCookieHeader setCookieHeader(CookieName name, CookieValue value) {
        Validators.validateNotNull(name, "name");
        Validators.validateNotNull(value, "value");
        return new SetCookieHeader(name, value);
    }

    public String compile() {
        return String.format("%s=\"%s\"", this.name.stringValue(), this.value.stringValue());
    }

    public String toString() {
        return "SetCookieHeader(name=" + this.name + ", value=" + this.value + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetCookieHeader)) {
            return false;
        }
        SetCookieHeader other = (SetCookieHeader)o;
        CookieName this$name = this.name;
        CookieName other$name = other.name;
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        CookieValue this$value = this.value;
        CookieValue other$value = other.value;
        return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CookieName $name = this.name;
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        CookieValue $value = this.value;
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        return result;
    }

    private SetCookieHeader(CookieName name, CookieValue value) {
        this.name = name;
        this.value = value;
    }
}

