/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.logger;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.logger.Logger;
import de.quantummaid.httpmaid.logger.LoggerImplementation;
import de.quantummaid.httpmaid.util.Validators;

public final class SetLoggerProcessor
implements Processor {
    private final LoggerImplementation loggerImplementation;

    public static Processor setLoggerProcessor(LoggerImplementation loggerImplementation) {
        Validators.validateNotNull(loggerImplementation, "loggerImplementation");
        return new SetLoggerProcessor(loggerImplementation);
    }

    @Override
    public void apply(MetaData metaData) {
        Logger logger = Logger.logger(this.loggerImplementation, metaData);
        metaData.set(HttpMaidChainKeys.LOGGER, logger);
    }

    public String toString() {
        return "SetLoggerProcessor(loggerImplementation=" + this.loggerImplementation + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetLoggerProcessor)) {
            return false;
        }
        SetLoggerProcessor other = (SetLoggerProcessor)o;
        LoggerImplementation this$loggerImplementation = this.loggerImplementation;
        LoggerImplementation other$loggerImplementation = other.loggerImplementation;
        return !(this$loggerImplementation == null ? other$loggerImplementation != null : !this$loggerImplementation.equals(other$loggerImplementation));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoggerImplementation $loggerImplementation = this.loggerImplementation;
        result = result * 59 + ($loggerImplementation == null ? 43 : $loggerImplementation.hashCode());
        return result;
    }

    private SetLoggerProcessor(LoggerImplementation loggerImplementation) {
        this.loggerImplementation = loggerImplementation;
    }
}

