/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.util.describing;

final class DescriptionUtils {
    static final String HORIZONTAL_THICK = "=";
    static final String HORIZONTAL_THIN = "-";
    static final String VERTICAL = "|";

    private DescriptionUtils() {
    }

    static String center(String string, int width) {
        int length = string.length();
        int missingWhitespace = width - length;
        int leftWhitespaceLength = missingWhitespace / 2;
        String leftWhitespace = DescriptionUtils.times(" ", leftWhitespaceLength);
        return DescriptionUtils.pad(String.format("%s%s", leftWhitespace, string), width);
    }

    static String pad(String string, int width) {
        int length = string.length();
        int whitespaceLength = width - length;
        String whitespace = DescriptionUtils.times(" ", whitespaceLength);
        return String.format("%s%s", string, whitespace);
    }

    static String times(String sequence, int times) {
        if (times < 0) {
            return "";
        }
        return sequence.repeat(times);
    }
}

