/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets;

import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.http.HeaderName;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketsModule;
import de.quantummaid.httpmaid.websockets.additionaldata.AdditionalWebsocketDataProvider;
import de.quantummaid.httpmaid.websockets.authorization.WebsocketAuthorizer;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class WebsocketConfigurators {
    private WebsocketConfigurators() {
    }

    public static Configurator toStoreAdditionalDataInWebsocketContext(AdditionalWebsocketDataProvider dataProvider) {
        Validators.validateNotNull(dataProvider, "dataProvider");
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setAdditionalWebsocketDataProvider(dataProvider));
    }

    public static Configurator toSelectWebsocketRoutesBasedOn(String routeSelectionExpression) {
        Validators.validateNotNull(routeSelectionExpression, "routeSelectionExpression");
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setRouteSelectionExpression(routeSelectionExpression));
    }

    public static Configurator toUseWebsocketRegistry(WebsocketRegistry websocketRegistry) {
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setWebsocketRegistry(websocketRegistry));
    }

    public static Configurator toAuthorizeWebsocketsUsing(WebsocketAuthorizer authorizer) {
        Validators.validateNotNull(authorizer, "authorizer");
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setWebsocketAuthorizer(authorizer));
    }

    public static Configurator toRememberHeadersInWebsocketMessages(String ... headerNames) {
        List<HeaderName> list = Arrays.stream(headerNames).map(HeaderName::headerName).collect(Collectors.toList());
        return WebsocketConfigurators.toRememberHeadersInWebsocketMessages(list);
    }

    public static Configurator toRememberHeadersInWebsocketMessages(List<HeaderName> headerNames) {
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> headerNames.forEach(websocketsModule::addAllowedHeaderInRegistry));
    }
}

