/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.broadcast;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.marshalling.Marshaller;
import de.quantummaid.httpmaid.marshalling.Marshallers;
import de.quantummaid.httpmaid.serialization.Serializer;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.broadcast.BroadcasterFactory;
import de.quantummaid.httpmaid.websockets.broadcast.RegisteredBroadcasterFactory;
import de.quantummaid.httpmaid.websockets.broadcast.SerializingSender;
import de.quantummaid.httpmaid.websockets.disconnect.Disconnector;
import de.quantummaid.httpmaid.websockets.disconnect.DisconnectorFactory;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public final class Broadcasters {
    public static final MetaDataKey<Broadcasters> BROADCASTERS = MetaDataKey.metaDataKey("BROADCASTERS");
    private final Map<GenericType<?>, RegisteredBroadcasterFactory> broadcasterFactories = new LinkedHashMap();
    private final Map<GenericType<?>, DisconnectorFactory<?>> disconnectorFactories = new LinkedHashMap();

    public static Broadcasters broadcasters() {
        return new Broadcasters();
    }

    public <T, U> void addBroadcaster(GenericType<T> type, ResolvedType messageType, BroadcasterFactory<T, U> factory) {
        RegisteredBroadcasterFactory registeredFactory = RegisteredBroadcasterFactory.registeredBroadcasterFactory(factory, type, messageType);
        this.broadcasterFactories.put(type, registeredFactory);
    }

    public <T> void addDisconnector(GenericType<T> type, DisconnectorFactory<T> factory) {
        this.disconnectorFactories.put(type, factory);
    }

    public List<GenericType<?>> injectionTypes() {
        ArrayList injectionTypes = new ArrayList();
        injectionTypes.addAll(this.broadcasterFactories.keySet());
        injectionTypes.addAll(this.disconnectorFactories.keySet());
        return injectionTypes;
    }

    public List<ResolvedType> messageTypes() {
        return this.broadcasterFactories.values().stream().map(RegisteredBroadcasterFactory::messageType).collect(Collectors.toList());
    }

    public <T> T instantiateBroadcaster(GenericType<T> type, WebsocketRegistry websocketRegistry, WebsocketSenders websocketSenders, Serializer serializer, Marshaller marshaller, MetaData metaData) {
        RegisteredBroadcasterFactory broadcasterFactory = this.broadcasterFactories.get(type);
        NotNullValidator.validateNotNull((Object)broadcasterFactory, (String)"broadcasterFactory");
        ResolvedType messageType = broadcasterFactory.messageType();
        SerializingSender serializingSender = SerializingSender.serializingSender(websocketRegistry, websocketSenders, messageType, marshaller, serializer, metaData);
        BroadcasterFactory<?, Object> factory = broadcasterFactory.factory();
        return (T)factory.createBroadcaster(serializingSender);
    }

    public <T> T instantiateDisconnector(GenericType<T> type, WebsocketRegistry websocketRegistry, WebsocketSenders websocketSenders, MetaData metaData) {
        DisconnectorFactory<?> disconnectorFactory = this.disconnectorFactories.get(type);
        NotNullValidator.validateNotNull(disconnectorFactory, (String)"disconnectorFactory");
        Disconnector disconnector = Disconnector.disconnector(websocketRegistry, websocketSenders, metaData);
        return (T)disconnectorFactory.createDisconnector(disconnector);
    }

    public List<Object> instantiateAll(MetaData metaData) {
        if (this.broadcasterFactories.isEmpty() && this.disconnectorFactories.isEmpty()) {
            return Collections.emptyList();
        }
        WebsocketSenders websocketSenders = metaData.get(WebsocketSenders.WEBSOCKET_SENDERS);
        WebsocketRegistry websocketRegistry = metaData.get(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY);
        Serializer serializer = metaData.get(Serializer.SERIALIZER);
        ArrayList<Object> instances = new ArrayList<Object>();
        Marshallers marshallers = metaData.get(Marshallers.MARSHALLERS);
        Marshaller marshaller = marshallers.determineResponseMarshaller(metaData);
        this.broadcasterFactories.keySet().stream().map(type -> this.instantiateBroadcaster((GenericType)type, websocketRegistry, websocketSenders, serializer, marshaller, metaData)).forEach(instances::add);
        Disconnector disconnector = Disconnector.disconnector(websocketRegistry, websocketSenders, metaData);
        this.disconnectorFactories.values().stream().map(disconnectorFactory -> disconnectorFactory.createDisconnector(disconnector)).forEach(instances::add);
        return instances;
    }

    @Generated
    public String toString() {
        return "Broadcasters(broadcasterFactories=" + this.broadcasterFactories + ", disconnectorFactories=" + this.disconnectorFactories + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Broadcasters)) {
            return false;
        }
        Broadcasters other = (Broadcasters)o;
        Map<GenericType<?>, RegisteredBroadcasterFactory> this$broadcasterFactories = this.broadcasterFactories;
        Map<GenericType<?>, RegisteredBroadcasterFactory> other$broadcasterFactories = other.broadcasterFactories;
        if (this$broadcasterFactories == null ? other$broadcasterFactories != null : !((Object)this$broadcasterFactories).equals(other$broadcasterFactories)) {
            return false;
        }
        Map<GenericType<?>, DisconnectorFactory<?>> this$disconnectorFactories = this.disconnectorFactories;
        Map<GenericType<?>, DisconnectorFactory<?>> other$disconnectorFactories = other.disconnectorFactories;
        return !(this$disconnectorFactories == null ? other$disconnectorFactories != null : !((Object)this$disconnectorFactories).equals(other$disconnectorFactories));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<GenericType<?>, RegisteredBroadcasterFactory> $broadcasterFactories = this.broadcasterFactories;
        result = result * 59 + ($broadcasterFactories == null ? 43 : ((Object)$broadcasterFactories).hashCode());
        Map<GenericType<?>, DisconnectorFactory<?>> $disconnectorFactories = this.disconnectorFactories;
        result = result * 59 + ($disconnectorFactories == null ? 43 : ((Object)$disconnectorFactories).hashCode());
        return result;
    }

    @Generated
    private Broadcasters() {
    }
}

