/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.processors;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.http.Header;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameter;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import de.quantummaid.httpmaid.websockets.registry.filter.header.HeaderFilter;
import de.quantummaid.httpmaid.websockets.registry.filter.queryparameter.QueryParameterFilter;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import de.quantummaid.reflectmaid.validators.NotNullValidator;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class CreateWebsocketRegistryEntryProcessor
implements Processor {
    private final HeaderFilter headerFilter;
    private final QueryParameterFilter queryParameterFilter;

    public static CreateWebsocketRegistryEntryProcessor createWebsocketRegistryEntryProcessor(HeaderFilter headerFilter, QueryParameterFilter queryParameterFilter) {
        NotNullValidator.validateNotNull((Object)headerFilter, (String)"headerFilter");
        NotNullValidator.validateNotNull((Object)queryParameterFilter, (String)"queryParameterFilter");
        return new CreateWebsocketRegistryEntryProcessor(headerFilter, queryParameterFilter);
    }

    @Override
    public void apply(MetaData metaData) {
        ConnectionInformation connectionInformation = ConnectionInformation.dummyConnectionInformation();
        WebsocketSenderId senderId = metaData.get(WebsocketSenderId.WEBSOCKET_SENDER_ID);
        Headers headers = this.filteredHeaders(metaData);
        QueryParameters queryParameters = this.filteredQueryParameters(metaData);
        Map<String, Object> additionalData = metaData.get(WebsocketMetaDataKeys.ADDITIONAL_WEBSOCKET_DATA);
        WebsocketRegistryEntry entry = WebsocketRegistryEntry.websocketRegistryEntry(connectionInformation, senderId, headers, queryParameters, additionalData);
        metaData.set(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY_ENTRY, entry);
    }

    private Headers filteredHeaders(MetaData metaData) {
        Headers headers = metaData.get(HttpMaidChainKeys.REQUEST_HEADERS);
        List<Header> filteredHeaders = this.headerFilter.filter(headers.asList());
        return Headers.headers(filteredHeaders);
    }

    private QueryParameters filteredQueryParameters(MetaData metaData) {
        QueryParameters queryParameters = metaData.get(HttpMaidChainKeys.QUERY_PARAMETERS);
        List<QueryParameter> filteredQueryParameters = this.queryParameterFilter.filter(queryParameters.asList());
        return QueryParameters.queryParameters(filteredQueryParameters);
    }

    @Generated
    private CreateWebsocketRegistryEntryProcessor(HeaderFilter headerFilter, QueryParameterFilter queryParameterFilter) {
        this.headerFilter = headerFilter;
        this.queryParameterFilter = queryParameterFilter;
    }
}

