/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.registry;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import java.util.Map;
import lombok.Generated;

public final class WebsocketRegistryEntry {
    private final ConnectionInformation connectionInformation;
    private final WebsocketSenderId senderId;
    private final Headers headers;
    private final QueryParameters queryParameters;
    private final Map<String, Object> additionalData;

    public static WebsocketRegistryEntry websocketRegistryEntry(ConnectionInformation connectionInformation, WebsocketSenderId senderId, Headers headers, QueryParameters queryParameters, Map<String, Object> additionalData) {
        Validators.validateNotNull(connectionInformation, "connectionInformation");
        Validators.validateNotNull(senderId, "senderId");
        Validators.validateNotNull(headers, "headers");
        Validators.validateNotNull(queryParameters, "queryParameters");
        Validators.validateNotNull(additionalData, "additionalData");
        return new WebsocketRegistryEntry(connectionInformation, senderId, headers, queryParameters, additionalData);
    }

    public static WebsocketRegistryEntry restoreFromStrings(ConnectionInformation connectionInformation, String senderId, Headers headers, QueryParameters queryParameters, Map<String, Object> additionalData) {
        WebsocketSenderId websocketSenderId = WebsocketSenderId.websocketSenderId(senderId);
        return WebsocketRegistryEntry.websocketRegistryEntry(connectionInformation, websocketSenderId, headers, queryParameters, additionalData);
    }

    public WebsocketRegistryEntry fixConnectionInformation(ConnectionInformation connectionInformation) {
        return new WebsocketRegistryEntry(connectionInformation, this.senderId, this.headers, this.queryParameters, this.additionalData);
    }

    public WebsocketSenderId senderId() {
        return this.senderId;
    }

    public ConnectionInformation connectionInformation() {
        return this.connectionInformation;
    }

    public WebsocketSenderId getSenderId() {
        return this.senderId;
    }

    public Headers headers() {
        return this.headers;
    }

    public QueryParameters queryParameters() {
        return this.queryParameters;
    }

    public Map<String, Object> additionalData() {
        return this.additionalData;
    }

    public void restoreToMetaData(MetaData metaData) {
        metaData.set(HttpMaidChainKeys.REQUEST_HEADERS, this.headers);
        metaData.set(HttpMaidChainKeys.QUERY_PARAMETERS, this.queryParameters);
        metaData.set(WebsocketMetaDataKeys.ADDITIONAL_WEBSOCKET_DATA, this.additionalData);
    }

    @Generated
    public String toString() {
        return "WebsocketRegistryEntry(connectionInformation=" + this.connectionInformation + ", senderId=" + this.getSenderId() + ", headers=" + this.headers + ", queryParameters=" + this.queryParameters + ", additionalData=" + this.additionalData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebsocketRegistryEntry)) {
            return false;
        }
        WebsocketRegistryEntry other = (WebsocketRegistryEntry)o;
        ConnectionInformation this$connectionInformation = this.connectionInformation;
        ConnectionInformation other$connectionInformation = other.connectionInformation;
        if (this$connectionInformation == null ? other$connectionInformation != null : !this$connectionInformation.equals(other$connectionInformation)) {
            return false;
        }
        WebsocketSenderId this$senderId = this.getSenderId();
        WebsocketSenderId other$senderId = other.getSenderId();
        if (this$senderId == null ? other$senderId != null : !((Object)this$senderId).equals(other$senderId)) {
            return false;
        }
        Headers this$headers = this.headers;
        Headers other$headers = other.headers;
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        QueryParameters this$queryParameters = this.queryParameters;
        QueryParameters other$queryParameters = other.queryParameters;
        if (this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters)) {
            return false;
        }
        Map<String, Object> this$additionalData = this.additionalData;
        Map<String, Object> other$additionalData = other.additionalData;
        return !(this$additionalData == null ? other$additionalData != null : !((Object)this$additionalData).equals(other$additionalData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConnectionInformation $connectionInformation = this.connectionInformation;
        result = result * 59 + ($connectionInformation == null ? 43 : $connectionInformation.hashCode());
        WebsocketSenderId $senderId = this.getSenderId();
        result = result * 59 + ($senderId == null ? 43 : ((Object)$senderId).hashCode());
        Headers $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        QueryParameters $queryParameters = this.queryParameters;
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        Map<String, Object> $additionalData = this.additionalData;
        result = result * 59 + ($additionalData == null ? 43 : ((Object)$additionalData).hashCode());
        return result;
    }

    @Generated
    private WebsocketRegistryEntry(ConnectionInformation connectionInformation, WebsocketSenderId senderId, Headers headers, QueryParameters queryParameters, Map<String, Object> additionalData) {
        this.connectionInformation = connectionInformation;
        this.senderId = senderId;
        this.headers = headers;
        this.queryParameters = queryParameters;
        this.additionalData = additionalData;
    }
}

