/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid;

import de.quantummaid.httpmaid.CoreModule;
import de.quantummaid.httpmaid.HttpMaidBuilder;
import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.HttpMaidException;
import de.quantummaid.httpmaid.RuntimeInformation;
import de.quantummaid.httpmaid.chains.ChainRegistry;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.closing.ClosingActions;
import de.quantummaid.httpmaid.endpoint.RawRequest;
import de.quantummaid.httpmaid.endpoint.RawRequestExtractor;
import de.quantummaid.httpmaid.endpoint.RawResponse;
import de.quantummaid.httpmaid.endpoint.RawResponseFactory;
import de.quantummaid.httpmaid.endpoint.RawResponseHandler;
import de.quantummaid.httpmaid.endpoint.SynchronizationWrapper;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.marshalling.Marshaller;
import de.quantummaid.httpmaid.marshalling.Marshallers;
import de.quantummaid.httpmaid.serialization.Serializer;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.broadcast.Broadcasters;
import de.quantummaid.httpmaid.websockets.broadcast.NonSerializingSender;
import de.quantummaid.httpmaid.websockets.broadcast.SerializingSender;
import de.quantummaid.httpmaid.websockets.disconnect.Disconnector;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSender;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ReflectMaid;
import de.quantummaid.reflectmaid.resolvedtype.ResolvedType;
import java.time.Duration;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpMaid
implements AutoCloseable {
    public static final MetaDataKey<Duration> STARTUP_TIME = MetaDataKey.metaDataKey("STARTUP_TIME");
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpMaid.class);
    private final ChainRegistry chainRegistry;

    public static HttpMaid httpMaid(ChainRegistry chainRegistry) {
        Validators.validateNotNull(chainRegistry, "chainRegistry");
        return new HttpMaid(chainRegistry);
    }

    public <T> T handleRequestSynchronously(RawRequestExtractor<RawRequest> rawRequestExtractor, RawResponseFactory<T> rawResponseFactory) {
        SynchronizationWrapper synchronizationWrapper = SynchronizationWrapper.synchronizationWrapper();
        this.handleRequest(rawRequestExtractor, response -> {
            Object returnedResponse = rawResponseFactory.createResponse(response);
            synchronizationWrapper.setObject(returnedResponse);
        });
        return synchronizationWrapper.getObject();
    }

    public void handleRequest(RawRequestExtractor<RawRequest> rawRequestExtractor, RawResponseHandler rawResponseHandler) {
        RawRequest rawHttpRequest;
        try {
            rawHttpRequest = rawRequestExtractor.extract();
        }
        catch (Exception e) {
            LOGGER.error("Exception in endpoint request handling", (Throwable)e);
            return;
        }
        MetaData metaData = MetaData.emptyMetaData();
        rawHttpRequest.enter(metaData);
        this.chainRegistry.putIntoChain(HttpMaidChains.INIT, metaData, finalMetaData -> {
            RawResponse rawResponse = RawResponse.rawResponse(finalMetaData);
            try {
                rawResponseHandler.handle(rawResponse);
            }
            catch (Exception e) {
                LOGGER.error("Exception in endpoint reponse handling", (Throwable)e);
            }
        });
    }

    public void addWebsocketSender(WebsocketSenderId websocketSenderId, WebsocketSender<?> websocketSender) {
        WebsocketSenders websocketSenders = this.getMetaDatum(WebsocketSenders.WEBSOCKET_SENDERS);
        websocketSenders.addWebsocketSender(websocketSenderId, websocketSender);
    }

    public <T> Optional<T> getOptionalMetaDatum(MetaDataKey<T> key) {
        Validators.validateNotNull(key, "key");
        return this.chainRegistry.getOptionalMetaDatum(key);
    }

    public <T> void setMetaDatum(MetaDataKey<T> key, T value) {
        this.chainRegistry.addMetaDatum(key, value);
    }

    public <T> T getMetaDatum(MetaDataKey<T> key) {
        Validators.validateNotNull(key, "key");
        return this.chainRegistry.getMetaDatum(key);
    }

    public String dumpChains() {
        return this.chainRegistry.dump();
    }

    public RuntimeInformation queryRuntimeInformation() {
        WebsocketRegistry websocketRegistry = this.chainRegistry.getMetaDatum(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY).get();
        long numberOfConnectedWebsockets = websocketRegistry.countConnections();
        return RuntimeInformation.runtimeInformation(numberOfConnectedWebsockets);
    }

    public NonSerializingSender websocketSender() {
        WebsocketRegistry websocketRegistry = this.getMetaDatum(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY).get();
        WebsocketSenders websocketSenders = this.getMetaDatum(WebsocketSenders.WEBSOCKET_SENDERS);
        return NonSerializingSender.nonSerializingSender(websocketRegistry, websocketSenders, MetaData.emptyMetaData());
    }

    public <T> SerializingSender<T> websocketSender(Class<T> messageType) {
        return this.websocketSender(messageType, ContentType.json());
    }

    public <T> SerializingSender<T> websocketSender(Class<T> messageType, ContentType contentType) {
        GenericType genericType = GenericType.genericType(messageType);
        return this.websocketSender(genericType, contentType);
    }

    public <T> SerializingSender<T> websocketSender(GenericType<T> messageType, ContentType contentType) {
        Marshallers marshallers = this.getMetaDatum(Marshallers.MARSHALLERS);
        Marshaller marshaller = marshallers.marshallerFor(contentType);
        WebsocketRegistry websocketRegistry = this.getMetaDatum(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY).get();
        WebsocketSenders websocketSenders = this.getMetaDatum(WebsocketSenders.WEBSOCKET_SENDERS);
        Serializer serializer = this.getMetaDatum(Serializer.SERIALIZER);
        ReflectMaid reflectMaid = this.getMetaDatum(CoreModule.REFLECT_MAID);
        ResolvedType resolvedMessageType = reflectMaid.resolve(messageType);
        return SerializingSender.serializingSender(websocketRegistry, websocketSenders, resolvedMessageType, marshaller, serializer, MetaData.emptyMetaData());
    }

    public <T> T websocketBroadcaster(Class<T> broadcasterType) {
        return this.websocketBroadcaster(broadcasterType, ContentType.json());
    }

    public <T> T websocketBroadcaster(Class<T> broadcasterType, ContentType contentType) {
        GenericType genericType = GenericType.genericType(broadcasterType);
        return this.websocketBroadcaster(genericType, contentType);
    }

    public <T> T websocketBroadcaster(GenericType<T> broadcasterType, ContentType contentType) {
        Marshallers marshallers = this.getMetaDatum(Marshallers.MARSHALLERS);
        Marshaller marshaller = marshallers.marshallerFor(contentType);
        WebsocketRegistry websocketRegistry = this.getMetaDatum(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY).get();
        WebsocketSenders websocketSenders = this.getMetaDatum(WebsocketSenders.WEBSOCKET_SENDERS);
        Serializer serializer = this.getMetaDatum(Serializer.SERIALIZER);
        Broadcasters broadcasters = this.getMetaDatum(Broadcasters.BROADCASTERS);
        return broadcasters.instantiateBroadcaster(broadcasterType, websocketRegistry, websocketSenders, serializer, marshaller, MetaData.emptyMetaData());
    }

    public Disconnector websocketDisconnector() {
        WebsocketRegistry websocketRegistry = this.getMetaDatum(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY).get();
        WebsocketSenders websocketSenders = this.getMetaDatum(WebsocketSenders.WEBSOCKET_SENDERS);
        return Disconnector.disconnector(websocketRegistry, websocketSenders, MetaData.emptyMetaData());
    }

    public <T> T websocketDisconnector(Class<T> disconnectorType) {
        GenericType genericType = GenericType.genericType(disconnectorType);
        return this.websocketDisconnector(genericType);
    }

    public <T> T websocketDisconnector(GenericType<T> disconnectorType) {
        WebsocketRegistry websocketRegistry = this.getMetaDatum(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY).get();
        WebsocketSenders websocketSenders = this.getMetaDatum(WebsocketSenders.WEBSOCKET_SENDERS);
        Broadcasters broadcasters = this.getMetaDatum(Broadcasters.BROADCASTERS);
        return broadcasters.instantiateDisconnector(disconnectorType, websocketRegistry, websocketSenders, MetaData.emptyMetaData());
    }

    public static HttpMaidBuilder anHttpMaid() {
        ReflectMaid reflectMaid = ReflectMaid.aReflectMaid();
        return HttpMaid.anHttpMaid(reflectMaid);
    }

    public static HttpMaidBuilder anHttpMaid(ReflectMaid reflectMaid) {
        return HttpMaidBuilder.httpMaidBuilder(reflectMaid);
    }

    @Override
    public void close() {
        ClosingActions closingActions = this.chainRegistry.getMetaDatum(ClosingActions.CLOSING_ACTIONS);
        try {
            closingActions.closeAll();
        }
        catch (Exception e) {
            throw HttpMaidException.httpMaidException("exception during closing of HttpMaid", e);
        }
    }

    public ReflectMaid reflectMaid() {
        return this.chainRegistry.getMetaDatum(CoreModule.REFLECT_MAID);
    }

    @Generated
    private HttpMaid(ChainRegistry chainRegistry) {
        this.chainRegistry = chainRegistry;
    }
}

