/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.http;

import de.quantummaid.httpmaid.http.QueryParameter;
import de.quantummaid.httpmaid.http.QueryParameterName;
import de.quantummaid.httpmaid.http.QueryParameterValue;
import de.quantummaid.httpmaid.http.QueryParameters;
import java.util.ArrayList;
import java.util.List;

public class QueryParametersBuilder {
    final List<QueryParameter> parameters = new ArrayList<QueryParameter>();

    public QueryParametersBuilder withParameter(String name, List<String> values) {
        QueryParameterName queryParameterName = QueryParameterName.queryParameterName(name);
        values.forEach(value -> this.addParameter(queryParameterName, (String)value));
        return this;
    }

    public QueryParametersBuilder withParameter(String name, String value) {
        QueryParameterName queryParameterName = QueryParameterName.queryParameterName(name);
        this.addParameter(queryParameterName, value);
        return this;
    }

    private void addParameter(QueryParameterName name, String value) {
        QueryParameterValue queryParameterValue = QueryParameterValue.queryParameterValue(value);
        this.parameters.add(QueryParameter.queryParameter(name, queryParameterValue));
    }

    public QueryParameters build() {
        return QueryParameters.queryParameters(this.parameters);
    }
}

