/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mappath;

import de.quantummaid.httpmaid.mappath.IndexMapPathElement;
import de.quantummaid.httpmaid.mappath.KeyMapPathElement;
import de.quantummaid.httpmaid.mappath.MapPathElement;
import de.quantummaid.httpmaid.mappath.Retrieval;
import de.quantummaid.httpmaid.mappath.rendering.RenderedElement;
import de.quantummaid.httpmaid.mappath.statemachine.StateMachine;
import de.quantummaid.httpmaid.util.Validators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public final class MapPath {
    private final List<MapPathElement> elements;

    public static MapPath parse(String mapPath) {
        Validators.validateNotNull(mapPath, "mapPath");
        List<MapPathElement> elements = StateMachine.runStateMachineOn(mapPath);
        return new MapPath(elements);
    }

    public static MapPath mapPath() {
        return new MapPath(List.of());
    }

    public MapPath key(String key) {
        return this.extend(KeyMapPathElement.keyMapPathElement(key));
    }

    public MapPath index(int index) {
        return this.extend(IndexMapPathElement.indexMapPathElement(index));
    }

    private MapPath extend(MapPathElement element) {
        ArrayList<MapPathElement> newElements = new ArrayList<MapPathElement>(this.elements);
        newElements.add(element);
        return new MapPath(newElements);
    }

    public Object retrieve(Map<String, Object> map) {
        Retrieval retrieval = this.retrieveOptionally(map);
        Validators.validateNotNull(retrieval, "retrieval");
        return retrieval.value();
    }

    public Retrieval retrieveOptionally(Map<String, Object> map) {
        MapPathElement element;
        Object value = map;
        Retrieval retrieval = null;
        Iterator<MapPathElement> iterator = this.elements.iterator();
        while (iterator.hasNext() && !(retrieval = (element = iterator.next()).retrieve(value)).isError()) {
            value = retrieval.value();
        }
        return retrieval;
    }

    public String render() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.elements.size(); ++i) {
            MapPathElement element = this.elements.get(i);
            RenderedElement renderedElement = element.render();
            if (i != 0) {
                renderedElement.connector().ifPresent(stringBuilder::append);
            }
            String content = renderedElement.content();
            stringBuilder.append(content);
        }
        return stringBuilder.toString();
    }

    @Generated
    public String toString() {
        return "MapPath(elements=" + this.elements + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapPath)) {
            return false;
        }
        MapPath other = (MapPath)o;
        List<MapPathElement> this$elements = this.elements;
        List<MapPathElement> other$elements = other.elements;
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<MapPathElement> $elements = this.elements;
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        return result;
    }

    @Generated
    private MapPath(List<MapPathElement> elements) {
        this.elements = elements;
    }
}

