/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.criteria;

import de.quantummaid.httpmaid.mappath.MapPath;
import de.quantummaid.httpmaid.mappath.Retrieval;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import java.util.Map;
import lombok.Generated;

public final class AdditionalDataStringCriterion {
    private final MapPath key;
    private final String value;

    public static AdditionalDataStringCriterion additionalDataStringCriterion(MapPath key, String value) {
        Validators.validateNotNull(key, "key");
        Validators.validateNotNull(value, "value");
        return new AdditionalDataStringCriterion(key, value);
    }

    public boolean filter(WebsocketRegistryEntry entry) {
        Map<String, Object> additionalData = entry.additionalData();
        Retrieval retrieval = this.key.retrieveOptionally(additionalData);
        if (retrieval.isError()) {
            return false;
        }
        Object retrievedValue = retrieval.value();
        return this.value.equals(retrievedValue);
    }

    public MapPath key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    @Generated
    public String toString() {
        return "AdditionalDataStringCriterion(key=" + this.key + ", value=" + this.value + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdditionalDataStringCriterion)) {
            return false;
        }
        AdditionalDataStringCriterion other = (AdditionalDataStringCriterion)o;
        MapPath this$key = this.key;
        MapPath other$key = other.key;
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MapPath $key = this.key;
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    private AdditionalDataStringCriterion(MapPath key, String value) {
        this.key = key;
        this.value = value;
    }
}

