/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.processors;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.runtimeconfiguration.RuntimeConfigurationValue;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.authorization.AuthorizationDecision;
import de.quantummaid.httpmaid.websockets.authorization.WebsocketAuthorizer;
import lombok.Generated;

public final class AuthorizeWebsocketProcessor
implements Processor {
    private final RuntimeConfigurationValue<WebsocketAuthorizer> authorizer;

    public static Processor authorizeWebsocketProcessor(RuntimeConfigurationValue<WebsocketAuthorizer> authorizer) {
        return new AuthorizeWebsocketProcessor(authorizer);
    }

    @Override
    public void apply(MetaData metaData) {
        HttpRequest httpRequest = HttpRequest.httpRequest(metaData);
        AuthorizationDecision authorizationDecision = this.authorizer.get().isAuthorized(httpRequest);
        metaData.set(AuthorizationDecision.AUTHORIZATION_DECISION, authorizationDecision);
        metaData.set(WebsocketMetaDataKeys.ADDITIONAL_WEBSOCKET_DATA, authorizationDecision.additionalData());
    }

    @Generated
    private AuthorizeWebsocketProcessor(RuntimeConfigurationValue<WebsocketAuthorizer> authorizer) {
        this.authorizer = authorizer;
    }
}

