/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.exceptions;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.exceptions.ExceptionMapper;
import de.quantummaid.httpmaid.filtermap.FilterMap;
import de.quantummaid.httpmaid.util.Validators;

public final class ExceptionSerializer {
    private final FilterMap<Throwable, ExceptionMapper<Throwable>> exceptionMappers;

    public static ExceptionSerializer exceptionSerializer(FilterMap<Throwable, ExceptionMapper<Throwable>> exceptionMappers) {
        Validators.validateNotNull(exceptionMappers, "exceptionMappers");
        return new ExceptionSerializer(exceptionMappers);
    }

    public void serializeException(Throwable throwable, MetaData metaData) {
        Validators.validateNotNull(throwable, "throwable");
        ExceptionMapper<Throwable> mapper = this.exceptionMappers.get(throwable);
        mapper.map(throwable, metaData);
    }

    public String toString() {
        return "ExceptionSerializer(exceptionMappers=" + this.exceptionMappers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExceptionSerializer)) {
            return false;
        }
        ExceptionSerializer other = (ExceptionSerializer)o;
        FilterMap<Throwable, ExceptionMapper<Throwable>> this$exceptionMappers = this.exceptionMappers;
        FilterMap<Throwable, ExceptionMapper<Throwable>> other$exceptionMappers = other.exceptionMappers;
        return !(this$exceptionMappers == null ? other$exceptionMappers != null : !this$exceptionMappers.equals(other$exceptionMappers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FilterMap<Throwable, ExceptionMapper<Throwable>> $exceptionMappers = this.exceptionMappers;
        result = result * 59 + ($exceptionMappers == null ? 43 : $exceptionMappers.hashCode());
        return result;
    }

    private ExceptionSerializer(FilterMap<Throwable, ExceptionMapper<Throwable>> exceptionMappers) {
        this.exceptionMappers = exceptionMappers;
    }
}

