/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains.autoloading;

import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.autoloading.AutoloadingException;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.reflectmaid.ReflectMaid;
import de.quantummaid.reflectmaid.resolvedtype.ClassType;
import de.quantummaid.reflectmaid.resolvedtype.resolver.ResolvedMethod;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;

public final class Autoloader {
    private Autoloader() {
    }

    public static Optional<ChainModule> loadModule(ReflectMaid reflectMaid, String fullyQualifiedClassName) {
        Validators.validateNotNullNorEmpty(fullyQualifiedClassName, "fullyQualifiedClassName");
        return Autoloader.loadClass(fullyQualifiedClassName).map(clazz -> {
            ResolvedMethod staticInitializer = Autoloader.findStaticInitializer(reflectMaid, clazz);
            return Autoloader.invoke(staticInitializer);
        });
    }

    private static Optional<Class<? extends ChainModule>> loadClass(String fullyQualifiedClassName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass(fullyQualifiedClassName);
            return Optional.of(clazz);
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private static ResolvedMethod findStaticInitializer(ReflectMaid reflectMaid, Class<? extends ChainModule> clazz) {
        ClassType classType = (ClassType)reflectMaid.resolve(clazz);
        return classType.methods().stream().filter(ResolvedMethod::isPublic).filter(ResolvedMethod::isStatic).filter(method -> method.returnType().map(arg_0 -> ((ClassType)classType).equals(arg_0)).orElse(false)).filter(method -> method.getParameters().isEmpty()).findFirst().orElseThrow();
    }

    private static ChainModule invoke(ResolvedMethod staticInitializer) {
        Method method = staticInitializer.getMethod();
        try {
            return (ChainModule)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw AutoloadingException.autoloadingException(e);
        }
    }
}

