/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.closing;

import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.util.Validators;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public final class ClosingActions {
    public static final MetaDataKey<ClosingActions> CLOSING_ACTIONS = MetaDataKey.metaDataKey("CLOSING_ACTIONS");
    private final List<AutoCloseable> actions;

    public static ClosingActions closingActions() {
        return new ClosingActions(new LinkedList<AutoCloseable>());
    }

    public void addClosingAction(AutoCloseable autoCloseable) {
        Validators.validateNotNull(autoCloseable, "autoCloseable");
        this.actions.add(autoCloseable);
    }

    public void closeAll() throws Exception {
        for (AutoCloseable autoCloseable : this.actions) {
            autoCloseable.close();
        }
    }

    @Generated
    public String toString() {
        return "ClosingActions(actions=" + this.actions + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClosingActions)) {
            return false;
        }
        ClosingActions other = (ClosingActions)o;
        List<AutoCloseable> this$actions = this.actions;
        List<AutoCloseable> other$actions = other.actions;
        return !(this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<AutoCloseable> $actions = this.actions;
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        return result;
    }

    @Generated
    private ClosingActions(List<AutoCloseable> actions) {
        this.actions = actions;
    }
}

