/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mappath;

import de.quantummaid.httpmaid.mappath.MapPathElement;
import de.quantummaid.httpmaid.mappath.Retrieval;
import de.quantummaid.httpmaid.mappath.rendering.RenderedElement;
import java.util.List;
import lombok.Generated;

public final class IndexMapPathElement
implements MapPathElement {
    private final int index;

    public static IndexMapPathElement indexMapPathElement(int index) {
        return new IndexMapPathElement(index);
    }

    @Override
    public Retrieval retrieve(Object object) {
        if (!(object instanceof List)) {
            return Retrieval.error(String.format("expected a List in order to retrieve index '%d' but found: %s", this.index, object));
        }
        List list = (List)object;
        if (this.index >= list.size()) {
            return Retrieval.error(String.format("cannot retrieve index '%d' out of List because its size is '%d'", this.index, list.size()));
        }
        return Retrieval.success(list.get(this.index));
    }

    @Override
    public RenderedElement render() {
        return RenderedElement.renderedElement(String.format("[%d]", this.index));
    }

    @Generated
    public String toString() {
        return "IndexMapPathElement(index=" + this.index + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexMapPathElement)) {
            return false;
        }
        IndexMapPathElement other = (IndexMapPathElement)o;
        return this.index == other.index;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.index;
        return result;
    }

    @Generated
    private IndexMapPathElement(int index) {
        this.index = index;
    }
}

