/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mappath;

import de.quantummaid.httpmaid.mappath.MapPathElement;
import de.quantummaid.httpmaid.mappath.Retrieval;
import de.quantummaid.httpmaid.mappath.rendering.RenderedElement;
import java.util.Map;
import lombok.Generated;

public final class KeyMapPathElement
implements MapPathElement {
    private final String key;

    public static KeyMapPathElement keyMapPathElement(String key) {
        return new KeyMapPathElement(key);
    }

    @Override
    public Retrieval retrieve(Object object) {
        if (!(object instanceof Map)) {
            return Retrieval.error(String.format("expected a Map in order to retrieve key '%s' but found: %s", this.key, object));
        }
        Map map = (Map)object;
        if (!map.containsKey(this.key)) {
            return Retrieval.error(String.format("did not find key '%s' in Map", this.key));
        }
        Object value = map.get(this.key);
        return Retrieval.success(value);
    }

    @Override
    public RenderedElement render() {
        return RenderedElement.renderedElement(this.key, ".");
    }

    @Generated
    public String toString() {
        return "KeyMapPathElement(key=" + this.key + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyMapPathElement)) {
            return false;
        }
        KeyMapPathElement other = (KeyMapPathElement)o;
        String this$key = this.key;
        String other$key = other.key;
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    @Generated
    private KeyMapPathElement(String key) {
        this.key = key;
    }
}

