/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mappath.statemachine.states;

import de.quantummaid.httpmaid.mappath.statemachine.Transition;
import de.quantummaid.httpmaid.mappath.statemachine.states.ErrorState;
import de.quantummaid.httpmaid.mappath.statemachine.states.IndexState;
import de.quantummaid.httpmaid.mappath.statemachine.states.KeyState;
import de.quantummaid.httpmaid.mappath.statemachine.states.State;
import de.quantummaid.httpmaid.mappath.statemachine.states.SuccessState;
import lombok.Generated;

public final class AfterIndexState
implements State {
    public static State afterIndexState() {
        return new AfterIndexState();
    }

    @Override
    public Transition handleOpeningSquareBrackets() {
        return Transition.transitionTo(IndexState.indexState());
    }

    @Override
    public Transition handleClosingSquareBrackets() {
        return Transition.transitionTo(ErrorState.errorState("square brackets are closed without opening them before"));
    }

    @Override
    public Transition handleDot() {
        return Transition.transitionTo(KeyState.keyState());
    }

    @Override
    public Transition handleNumericCharacter(char c) {
        return this.handleNonNumericCharacter(c);
    }

    @Override
    public Transition handleNonNumericCharacter(char c) {
        return Transition.transitionTo(ErrorState.errorState(String.format("unexpected character '%s' ('.' or '[' expected)", Character.valueOf(c))));
    }

    @Override
    public Transition handleEnd() {
        return Transition.transitionTo(SuccessState.successState());
    }

    @Generated
    private AfterIndexState() {
    }
}

