/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.mappath.statemachine.states;

import de.quantummaid.httpmaid.mappath.IndexMapPathElement;
import de.quantummaid.httpmaid.mappath.statemachine.Transition;
import de.quantummaid.httpmaid.mappath.statemachine.states.AfterIndexState;
import de.quantummaid.httpmaid.mappath.statemachine.states.ErrorState;
import de.quantummaid.httpmaid.mappath.statemachine.states.State;
import lombok.Generated;

public final class IndexState
implements State {
    private final StringBuilder stringBuilder;

    public static IndexState indexState() {
        return new IndexState(new StringBuilder());
    }

    @Override
    public Transition handleOpeningSquareBrackets() {
        return Transition.transitionTo(ErrorState.errorState("square brackets are opened inside of square brackets"));
    }

    @Override
    public Transition handleClosingSquareBrackets() {
        if (this.stringBuilder.length() == 0) {
            return Transition.transitionTo(ErrorState.errorState("index is empty"));
        }
        String string = this.stringBuilder.toString();
        int index = Integer.parseInt(string);
        IndexMapPathElement pathElement = IndexMapPathElement.indexMapPathElement(index);
        return Transition.transitionTo(AfterIndexState.afterIndexState(), pathElement);
    }

    @Override
    public Transition handleDot() {
        return this.handleNonNumericCharacter('.');
    }

    @Override
    public Transition handleNumericCharacter(char c) {
        this.stringBuilder.append(c);
        return Transition.transitionTo(this);
    }

    @Override
    public Transition handleNonNumericCharacter(char c) {
        return Transition.transitionTo(ErrorState.errorState(String.format("non-digit character in array index: '%s'", Character.valueOf(c))));
    }

    @Override
    public Transition handleEnd() {
        return Transition.transitionTo(ErrorState.errorState("square brackets are never closed"));
    }

    @Generated
    public String toString() {
        return "IndexState(stringBuilder=" + this.stringBuilder + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexState)) {
            return false;
        }
        IndexState other = (IndexState)o;
        StringBuilder this$stringBuilder = this.stringBuilder;
        StringBuilder other$stringBuilder = other.stringBuilder;
        return !(this$stringBuilder == null ? other$stringBuilder != null : !this$stringBuilder.equals(other$stringBuilder));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        StringBuilder $stringBuilder = this.stringBuilder;
        result = result * 59 + ($stringBuilder == null ? 43 : $stringBuilder.hashCode());
        return result;
    }

    @Generated
    private IndexState(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
    }
}

