/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets;

import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.http.HeaderName;
import de.quantummaid.httpmaid.http.QueryParameterName;
import de.quantummaid.httpmaid.runtimeconfiguration.RuntimeConfigurationValueProvider;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketsModule;
import de.quantummaid.httpmaid.websockets.additionaldata.AdditionalWebsocketDataProvider;
import de.quantummaid.httpmaid.websockets.authorization.WebsocketAuthorizer;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.registry.filter.header.AllowAllHeaderFilter;
import de.quantummaid.httpmaid.websockets.registry.filter.header.AllowListHeaderFilter;
import de.quantummaid.httpmaid.websockets.registry.filter.header.HeaderFilter;
import de.quantummaid.httpmaid.websockets.registry.filter.queryparameter.AllowListQueryParameterFilter;
import de.quantummaid.httpmaid.websockets.registry.filter.queryparameter.QueryParameterFilter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class WebsocketConfigurators {
    private WebsocketConfigurators() {
    }

    public static Configurator toStoreAdditionalDataInWebsocketContext(AdditionalWebsocketDataProvider dataProvider) {
        Validators.validateNotNull(dataProvider, "dataProvider");
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setAdditionalWebsocketDataProvider(dataProvider));
    }

    public static Configurator toSelectWebsocketRoutesBasedOn(String routeSelectionExpression) {
        Validators.validateNotNull(routeSelectionExpression, "routeSelectionExpression");
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setRouteSelectionExpression(routeSelectionExpression));
    }

    public static Configurator toUseWebsocketRegistry(WebsocketRegistry websocketRegistry) {
        return WebsocketConfigurators.toUseWebsocketRegistry(() -> websocketRegistry);
    }

    public static Configurator toUseWebsocketRegistry(RuntimeConfigurationValueProvider<WebsocketRegistry> websocketRegistry) {
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setWebsocketRegistryProvider(websocketRegistry));
    }

    public static Configurator toAuthorizeWebsocketsUsing(WebsocketAuthorizer authorizer) {
        return WebsocketConfigurators.toAuthorizeWebsocketsUsing(() -> authorizer);
    }

    public static Configurator toAuthorizeWebsocketsUsing(RuntimeConfigurationValueProvider<WebsocketAuthorizer> authorizer) {
        Validators.validateNotNull(authorizer, "authorizer");
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setWebsocketAuthorizerProvider(authorizer));
    }

    public static Configurator toRememberAdditionalHeadersInWebsocketMessages(String ... headerNames) {
        List<HeaderName> list = Arrays.stream(headerNames).map(HeaderName::headerName).collect(Collectors.toList());
        return WebsocketConfigurators.toRememberAdditionalHeadersInWebsocketMessages(list);
    }

    public static Configurator toRememberAdditionalHeadersInWebsocketMessages(List<HeaderName> headerNames) {
        return WebsocketConfigurators.toFilterHeadersInWebsocketMessagesUsing(AllowListHeaderFilter.allowListHeaderFilter(headerNames));
    }

    public static Configurator toRememberAllHeadersInWebsocketMessages() {
        return WebsocketConfigurators.toFilterHeadersInWebsocketMessagesUsing(AllowAllHeaderFilter.allowAllHeaderFilter());
    }

    public static Configurator toFilterHeadersInWebsocketMessagesUsing(HeaderFilter filter) {
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setHeaderFilter(filter));
    }

    public static Configurator toDropAllQueryParametersInWebsocketMessages() {
        return WebsocketConfigurators.toRememberQueryParametersInWebsocketMessages(new String[0]);
    }

    public static Configurator toRememberQueryParametersInWebsocketMessages(String ... parameterNames) {
        List<QueryParameterName> list = Arrays.stream(parameterNames).map(QueryParameterName::queryParameterName).collect(Collectors.toList());
        return WebsocketConfigurators.toRememberQueryParametersInWebsocketMessages(list);
    }

    public static Configurator toRememberQueryParametersInWebsocketMessages(List<QueryParameterName> parameterNames) {
        return WebsocketConfigurators.toFilterQueryParametersInWebsocketMessagesUsing(AllowListQueryParameterFilter.allowListQueryParameterFilter(parameterNames));
    }

    public static Configurator toFilterQueryParametersInWebsocketMessagesUsing(QueryParameterFilter filter) {
        return Configurator.configuratorForType(WebsocketsModule.class, websocketsModule -> websocketsModule.setQueryParameterFilter(filter));
    }
}

