/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.endpoint;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.endpoint.RawRequest;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.endpoint.RawWebsocketConnectBuilder;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import java.util.Map;
import lombok.Generated;

public final class RawWebsocketConnect
implements RawRequest {
    private final ConnectionInformation connectionInformation;
    private final WebsocketSenderId websocketSenderId;
    private final WebsocketRegistryEntry registryEntry;
    private final Map<MetaDataKey<?>, Object> additionalMetaData;

    public static RawWebsocketConnectBuilder rawWebsocketConnectBuilder() {
        return RawWebsocketConnectBuilder.rawWebsocketConnectBuilder();
    }

    public static RawWebsocketConnect rawWebsocketConnect(ConnectionInformation connectionInformation, WebsocketSenderId websocketSenderId, WebsocketRegistryEntry registryEntry) {
        return RawWebsocketConnect.rawWebsocketConnect(connectionInformation, websocketSenderId, registryEntry, Map.of());
    }

    public static RawWebsocketConnect rawWebsocketConnect(ConnectionInformation connectionInformation, WebsocketSenderId websocketSenderId, WebsocketRegistryEntry registryEntry, Map<MetaDataKey<?>, Object> additionalMetaData) {
        Validators.validateNotNull(connectionInformation, "connectionInformation");
        Validators.validateNotNull(websocketSenderId, "websocketSenderId");
        Validators.validateNotNull(registryEntry, "registryEntry");
        Validators.validateNotNull(additionalMetaData, "additionalMetaData");
        return new RawWebsocketConnect(connectionInformation, websocketSenderId, registryEntry, additionalMetaData);
    }

    @Override
    public void enter(MetaData metaData) {
        metaData.set(WebsocketMetaDataKeys.WEBSOCKET_CONNECTION_INFORMATION, this.connectionInformation);
        metaData.set(WebsocketSenderId.WEBSOCKET_SENDER_ID, this.websocketSenderId);
        metaData.set(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY_ENTRY, this.registryEntry);
        metaData.set(WebsocketMetaDataKeys.REQUEST_TYPE, "WEBSOCKET_CONNECT");
        this.additionalMetaData.forEach(metaData::setUnchecked);
    }

    @Generated
    public String toString() {
        return "RawWebsocketConnect(connectionInformation=" + this.connectionInformation + ", websocketSenderId=" + this.websocketSenderId + ", registryEntry=" + this.registryEntry + ", additionalMetaData=" + this.additionalMetaData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawWebsocketConnect)) {
            return false;
        }
        RawWebsocketConnect other = (RawWebsocketConnect)o;
        ConnectionInformation this$connectionInformation = this.connectionInformation;
        ConnectionInformation other$connectionInformation = other.connectionInformation;
        if (this$connectionInformation == null ? other$connectionInformation != null : !this$connectionInformation.equals(other$connectionInformation)) {
            return false;
        }
        WebsocketSenderId this$websocketSenderId = this.websocketSenderId;
        WebsocketSenderId other$websocketSenderId = other.websocketSenderId;
        if (this$websocketSenderId == null ? other$websocketSenderId != null : !((Object)this$websocketSenderId).equals(other$websocketSenderId)) {
            return false;
        }
        WebsocketRegistryEntry this$registryEntry = this.registryEntry;
        WebsocketRegistryEntry other$registryEntry = other.registryEntry;
        if (this$registryEntry == null ? other$registryEntry != null : !((Object)this$registryEntry).equals(other$registryEntry)) {
            return false;
        }
        Map<MetaDataKey<?>, Object> this$additionalMetaData = this.additionalMetaData;
        Map<MetaDataKey<?>, Object> other$additionalMetaData = other.additionalMetaData;
        return !(this$additionalMetaData == null ? other$additionalMetaData != null : !((Object)this$additionalMetaData).equals(other$additionalMetaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConnectionInformation $connectionInformation = this.connectionInformation;
        result = result * 59 + ($connectionInformation == null ? 43 : $connectionInformation.hashCode());
        WebsocketSenderId $websocketSenderId = this.websocketSenderId;
        result = result * 59 + ($websocketSenderId == null ? 43 : ((Object)$websocketSenderId).hashCode());
        WebsocketRegistryEntry $registryEntry = this.registryEntry;
        result = result * 59 + ($registryEntry == null ? 43 : ((Object)$registryEntry).hashCode());
        Map<MetaDataKey<?>, Object> $additionalMetaData = this.additionalMetaData;
        result = result * 59 + ($additionalMetaData == null ? 43 : ((Object)$additionalMetaData).hashCode());
        return result;
    }

    @Generated
    private RawWebsocketConnect(ConnectionInformation connectionInformation, WebsocketSenderId websocketSenderId, WebsocketRegistryEntry registryEntry, Map<MetaDataKey<?>, Object> additionalMetaData) {
        this.connectionInformation = connectionInformation;
        this.websocketSenderId = websocketSenderId;
        this.registryEntry = registryEntry;
        this.additionalMetaData = additionalMetaData;
    }
}

