/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.endpoint;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.endpoint.RawRequest;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import java.util.Map;
import lombok.Generated;

public final class RawWebsocketMessage
implements RawRequest {
    private final ConnectionInformation connectionInformation;
    private final String body;
    private final WebsocketRegistryEntry registryEntry;
    private final Map<MetaDataKey<?>, Object> additionalMetaData;

    public static RawWebsocketMessage rawWebsocketMessage(ConnectionInformation connectionInformation, String body) {
        return RawWebsocketMessage.rawWebsocketMessage(connectionInformation, body, Map.of());
    }

    public static RawWebsocketMessage rawWebsocketMessage(ConnectionInformation connectionInformation, String body, Map<MetaDataKey<?>, Object> additionalMetaData) {
        Validators.validateNotNull(connectionInformation, "connectionInformation");
        Validators.validateNotNull(body, "body");
        Validators.validateNotNull(additionalMetaData, "additionalMetaData");
        return new RawWebsocketMessage(connectionInformation, body, null, additionalMetaData);
    }

    public static RawWebsocketMessage rawWebsocketMessageWithMetaData(ConnectionInformation connectionInformation, String body, WebsocketRegistryEntry registryEntry, Map<MetaDataKey<?>, Object> additionalMetaData) {
        Validators.validateNotNull(connectionInformation, "connectionInformation");
        Validators.validateNotNull(body, "body");
        Validators.validateNotNull(registryEntry, "registryEntry");
        Validators.validateNotNull(additionalMetaData, "additionalMetaData");
        return new RawWebsocketMessage(connectionInformation, body, registryEntry, additionalMetaData);
    }

    @Override
    public void enter(MetaData metaData) {
        metaData.set(WebsocketMetaDataKeys.REQUEST_TYPE, "WEBSOCKET_MESSAGE");
        metaData.set(HttpMaidChainKeys.IS_HTTP_REQUEST, false);
        metaData.set(WebsocketMetaDataKeys.WEBSOCKET_CONNECTION_INFORMATION, this.connectionInformation);
        metaData.set(HttpMaidChainKeys.REQUEST_BODY_STRING, this.body);
        this.additionalMetaData.forEach(metaData::setUnchecked);
        if (this.registryEntry != null) {
            metaData.set(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY_ENTRY, this.registryEntry);
        }
    }

    @Generated
    public String toString() {
        return "RawWebsocketMessage(connectionInformation=" + this.connectionInformation + ", body=" + this.body + ", registryEntry=" + this.registryEntry + ", additionalMetaData=" + this.additionalMetaData + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawWebsocketMessage)) {
            return false;
        }
        RawWebsocketMessage other = (RawWebsocketMessage)o;
        ConnectionInformation this$connectionInformation = this.connectionInformation;
        ConnectionInformation other$connectionInformation = other.connectionInformation;
        if (this$connectionInformation == null ? other$connectionInformation != null : !this$connectionInformation.equals(other$connectionInformation)) {
            return false;
        }
        String this$body = this.body;
        String other$body = other.body;
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        WebsocketRegistryEntry this$registryEntry = this.registryEntry;
        WebsocketRegistryEntry other$registryEntry = other.registryEntry;
        if (this$registryEntry == null ? other$registryEntry != null : !((Object)this$registryEntry).equals(other$registryEntry)) {
            return false;
        }
        Map<MetaDataKey<?>, Object> this$additionalMetaData = this.additionalMetaData;
        Map<MetaDataKey<?>, Object> other$additionalMetaData = other.additionalMetaData;
        return !(this$additionalMetaData == null ? other$additionalMetaData != null : !((Object)this$additionalMetaData).equals(other$additionalMetaData));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConnectionInformation $connectionInformation = this.connectionInformation;
        result = result * 59 + ($connectionInformation == null ? 43 : $connectionInformation.hashCode());
        String $body = this.body;
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        WebsocketRegistryEntry $registryEntry = this.registryEntry;
        result = result * 59 + ($registryEntry == null ? 43 : ((Object)$registryEntry).hashCode());
        Map<MetaDataKey<?>, Object> $additionalMetaData = this.additionalMetaData;
        result = result * 59 + ($additionalMetaData == null ? 43 : ((Object)$additionalMetaData).hashCode());
        return result;
    }

    @Generated
    private RawWebsocketMessage(ConnectionInformation connectionInformation, String body, WebsocketRegistryEntry registryEntry, Map<MetaDataKey<?>, Object> additionalMetaData) {
        this.connectionInformation = connectionInformation;
        this.body = body;
        this.registryEntry = registryEntry;
        this.additionalMetaData = additionalMetaData;
    }
}

