/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.registry.filter.header;

import de.quantummaid.httpmaid.http.Header;
import de.quantummaid.httpmaid.http.HeaderName;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.registry.filter.header.HeaderFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class AllowListHeaderFilter
implements HeaderFilter {
    private static final List<HeaderName> ALWAYS_ALLOWED = List.of(HeaderName.headerName("Content-Type"), HeaderName.headerName("Accept"));
    private final List<HeaderName> names;

    public static HeaderFilter onlyAllowingDefaultHeaders() {
        return AllowListHeaderFilter.allowListHeaderFilter(Collections.emptyList());
    }

    public static HeaderFilter allowListHeaderFilter(List<HeaderName> names) {
        Validators.validateNotNull(names, "names");
        ArrayList<HeaderName> allAllowedHeaders = new ArrayList<HeaderName>(names);
        ALWAYS_ALLOWED.forEach(headerName -> {
            if (!allAllowedHeaders.contains(headerName)) {
                allAllowedHeaders.add((HeaderName)headerName);
            }
        });
        return new AllowListHeaderFilter(allAllowedHeaders);
    }

    @Override
    public List<Header> filter(List<Header> headers) {
        return headers.stream().filter((? super T header) -> {
            HeaderName name = header.name();
            return this.names.contains(name);
        }).collect(Collectors.toList());
    }

    @Generated
    private AllowListHeaderFilter(List<HeaderName> names) {
        this.names = names;
    }
}

