/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets;

import de.quantummaid.httpmaid.CoreModule;
import de.quantummaid.httpmaid.HttpMaidChains;
import de.quantummaid.httpmaid.chains.ChainExtender;
import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.rules.Consume;
import de.quantummaid.httpmaid.chains.rules.Drop;
import de.quantummaid.httpmaid.chains.rules.Jump;
import de.quantummaid.httpmaid.runtimeconfiguration.RuntimeConfiguration;
import de.quantummaid.httpmaid.runtimeconfiguration.RuntimeConfigurationValue;
import de.quantummaid.httpmaid.runtimeconfiguration.RuntimeConfigurationValueProvider;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.additionaldata.AdditionalWebsocketDataProvider;
import de.quantummaid.httpmaid.websockets.authorization.AuthorizationDecision;
import de.quantummaid.httpmaid.websockets.authorization.WebsocketAuthorizer;
import de.quantummaid.httpmaid.websockets.processors.AddAdditionalWebsocketDataProcessor;
import de.quantummaid.httpmaid.websockets.processors.AddWebsocketsMetaDataProcessor;
import de.quantummaid.httpmaid.websockets.processors.AuthorizeWebsocketProcessor;
import de.quantummaid.httpmaid.websockets.processors.CreateWebsocketRegistryEntryProcessor;
import de.quantummaid.httpmaid.websockets.processors.DetermineWebsocketRouteProcessor;
import de.quantummaid.httpmaid.websockets.processors.PutWebsocketInRegistryProcessor;
import de.quantummaid.httpmaid.websockets.processors.RemoveWebsocketFromRegistryProcessor;
import de.quantummaid.httpmaid.websockets.processors.RestoreWebsocketContextInformationProcessor;
import de.quantummaid.httpmaid.websockets.registry.InMemoryRegistry;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.registry.filter.header.AllowListHeaderFilter;
import de.quantummaid.httpmaid.websockets.registry.filter.header.HeaderFilter;
import de.quantummaid.httpmaid.websockets.registry.filter.queryparameter.AllowAllQueryParameterFilter;
import de.quantummaid.httpmaid.websockets.registry.filter.queryparameter.QueryParameterFilter;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import java.util.Map;
import lombok.Generated;

public final class WebsocketsModule
implements ChainModule {
    private static final ChainName AUTHORIZE_WEBSOCKET = ChainName.chainName("AUTHORIZE_WEBSOCKET");
    private static final ChainName CONNECT_WEBSOCKET = ChainName.chainName("CONNECT_WEBSOCKET");
    private static final ChainName DISCONNECT_WEBSOCKET = ChainName.chainName("DISCONNECT_WEBSOCKET");
    private String routeSelectionExpression = "message";
    private RuntimeConfigurationValueProvider<WebsocketRegistry> websocketRegistryProvider = InMemoryRegistry::inMemoryRegistry;
    private AdditionalWebsocketDataProvider additionalWebsocketDataProvider = request -> Map.of();
    private RuntimeConfigurationValueProvider<WebsocketAuthorizer> websocketAuthorizerProvider = () -> request -> AuthorizationDecision.success();
    private HeaderFilter headerFilter = AllowListHeaderFilter.onlyAllowingDefaultHeaders();
    private QueryParameterFilter queryParameterFilter = AllowAllQueryParameterFilter.allowAllQueryParameterFilter();

    public static WebsocketsModule websocketsModule() {
        return new WebsocketsModule();
    }

    public void setRouteSelectionExpression(String routeSelectionExpression) {
        this.routeSelectionExpression = routeSelectionExpression;
    }

    public void setWebsocketRegistryProvider(RuntimeConfigurationValueProvider<WebsocketRegistry> websocketRegistryProvider) {
        this.websocketRegistryProvider = websocketRegistryProvider;
    }

    public void setAdditionalWebsocketDataProvider(AdditionalWebsocketDataProvider additionalWebsocketDataProvider) {
        this.additionalWebsocketDataProvider = additionalWebsocketDataProvider;
    }

    public void setWebsocketAuthorizerProvider(RuntimeConfigurationValueProvider<WebsocketAuthorizer> websocketAuthorizerProvider) {
        this.websocketAuthorizerProvider = websocketAuthorizerProvider;
    }

    public void setHeaderFilter(HeaderFilter headerFilter) {
        this.headerFilter = headerFilter;
    }

    public void setQueryParameterFilter(QueryParameterFilter queryParameterFilter) {
        this.queryParameterFilter = queryParameterFilter;
    }

    @Override
    public void register(ChainExtender extender) {
        RuntimeConfiguration runtimeConfiguration = extender.getMetaDatum(CoreModule.RUNTIME_CONFIGURATION);
        RuntimeConfigurationValue<WebsocketRegistry> websocketRegistry = runtimeConfiguration.create(this.websocketRegistryProvider);
        extender.addMetaDatum(WebsocketMetaDataKeys.WEBSOCKET_REGISTRY, websocketRegistry);
        WebsocketSenders websocketSenders = extender.getMetaDatum(WebsocketSenders.WEBSOCKET_SENDERS);
        extender.appendProcessor(HttpMaidChains.INIT, AddWebsocketsMetaDataProcessor.addWebsocketRegistryProcessor(websocketSenders, websocketRegistry));
        extender.appendProcessor(HttpMaidChains.PRE_PROCESS, RestoreWebsocketContextInformationProcessor.restoreWebsocketContextInformationProcessor());
        extender.routeIfEquals(HttpMaidChains.PRE_PROCESS, Jump.jumpTo(AUTHORIZE_WEBSOCKET), WebsocketMetaDataKeys.REQUEST_TYPE, "WEBSOCKET_AUTHORIZATION");
        extender.createChain(AUTHORIZE_WEBSOCKET, Consume.consume(), Jump.jumpTo(HttpMaidChains.EXCEPTION_OCCURRED));
        RuntimeConfigurationValue<WebsocketAuthorizer> websocketAuthorizer = runtimeConfiguration.create(this.websocketAuthorizerProvider);
        extender.appendProcessor(AUTHORIZE_WEBSOCKET, AuthorizeWebsocketProcessor.authorizeWebsocketProcessor(websocketAuthorizer));
        extender.appendProcessor(AUTHORIZE_WEBSOCKET, AddAdditionalWebsocketDataProcessor.addAdditionalWebsocketDataProcessor(this.additionalWebsocketDataProvider));
        extender.appendProcessor(AUTHORIZE_WEBSOCKET, CreateWebsocketRegistryEntryProcessor.createWebsocketRegistryEntryProcessor(this.headerFilter, this.queryParameterFilter));
        extender.routeIfEquals(HttpMaidChains.PRE_PROCESS, Jump.jumpTo(CONNECT_WEBSOCKET), WebsocketMetaDataKeys.REQUEST_TYPE, "WEBSOCKET_CONNECT");
        extender.createChain(CONNECT_WEBSOCKET, Drop.drop(), Jump.jumpTo(HttpMaidChains.EXCEPTION_OCCURRED));
        extender.appendProcessor(CONNECT_WEBSOCKET, PutWebsocketInRegistryProcessor.putWebsocketInRegistryProcessor());
        extender.appendProcessor(HttpMaidChains.PRE_DETERMINE_HANDLER, DetermineWebsocketRouteProcessor.determineWebsocketRouteProcessor(this.routeSelectionExpression));
        extender.routeIfEquals(HttpMaidChains.PRE_PROCESS, Jump.jumpTo(DISCONNECT_WEBSOCKET), WebsocketMetaDataKeys.REQUEST_TYPE, "WEBSOCKET_DISCONNECT");
        extender.createChain(DISCONNECT_WEBSOCKET, Drop.drop(), Jump.jumpTo(HttpMaidChains.EXCEPTION_OCCURRED));
        extender.appendProcessor(DISCONNECT_WEBSOCKET, RemoveWebsocketFromRegistryProcessor.removeWebsocketFromRegistryProcessor());
    }

    @Generated
    public String toString() {
        return "WebsocketsModule(routeSelectionExpression=" + this.routeSelectionExpression + ", websocketRegistryProvider=" + this.websocketRegistryProvider + ", additionalWebsocketDataProvider=" + this.additionalWebsocketDataProvider + ", websocketAuthorizerProvider=" + this.websocketAuthorizerProvider + ", headerFilter=" + this.headerFilter + ", queryParameterFilter=" + this.queryParameterFilter + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebsocketsModule)) {
            return false;
        }
        WebsocketsModule other = (WebsocketsModule)o;
        String this$routeSelectionExpression = this.routeSelectionExpression;
        String other$routeSelectionExpression = other.routeSelectionExpression;
        if (this$routeSelectionExpression == null ? other$routeSelectionExpression != null : !this$routeSelectionExpression.equals(other$routeSelectionExpression)) {
            return false;
        }
        RuntimeConfigurationValueProvider<WebsocketRegistry> this$websocketRegistryProvider = this.websocketRegistryProvider;
        RuntimeConfigurationValueProvider<WebsocketRegistry> other$websocketRegistryProvider = other.websocketRegistryProvider;
        if (this$websocketRegistryProvider == null ? other$websocketRegistryProvider != null : !this$websocketRegistryProvider.equals(other$websocketRegistryProvider)) {
            return false;
        }
        AdditionalWebsocketDataProvider this$additionalWebsocketDataProvider = this.additionalWebsocketDataProvider;
        AdditionalWebsocketDataProvider other$additionalWebsocketDataProvider = other.additionalWebsocketDataProvider;
        if (this$additionalWebsocketDataProvider == null ? other$additionalWebsocketDataProvider != null : !this$additionalWebsocketDataProvider.equals(other$additionalWebsocketDataProvider)) {
            return false;
        }
        RuntimeConfigurationValueProvider<WebsocketAuthorizer> this$websocketAuthorizerProvider = this.websocketAuthorizerProvider;
        RuntimeConfigurationValueProvider<WebsocketAuthorizer> other$websocketAuthorizerProvider = other.websocketAuthorizerProvider;
        if (this$websocketAuthorizerProvider == null ? other$websocketAuthorizerProvider != null : !this$websocketAuthorizerProvider.equals(other$websocketAuthorizerProvider)) {
            return false;
        }
        HeaderFilter this$headerFilter = this.headerFilter;
        HeaderFilter other$headerFilter = other.headerFilter;
        if (this$headerFilter == null ? other$headerFilter != null : !this$headerFilter.equals(other$headerFilter)) {
            return false;
        }
        QueryParameterFilter this$queryParameterFilter = this.queryParameterFilter;
        QueryParameterFilter other$queryParameterFilter = other.queryParameterFilter;
        return !(this$queryParameterFilter == null ? other$queryParameterFilter != null : !this$queryParameterFilter.equals(other$queryParameterFilter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $routeSelectionExpression = this.routeSelectionExpression;
        result = result * 59 + ($routeSelectionExpression == null ? 43 : $routeSelectionExpression.hashCode());
        RuntimeConfigurationValueProvider<WebsocketRegistry> $websocketRegistryProvider = this.websocketRegistryProvider;
        result = result * 59 + ($websocketRegistryProvider == null ? 43 : $websocketRegistryProvider.hashCode());
        AdditionalWebsocketDataProvider $additionalWebsocketDataProvider = this.additionalWebsocketDataProvider;
        result = result * 59 + ($additionalWebsocketDataProvider == null ? 43 : $additionalWebsocketDataProvider.hashCode());
        RuntimeConfigurationValueProvider<WebsocketAuthorizer> $websocketAuthorizerProvider = this.websocketAuthorizerProvider;
        result = result * 59 + ($websocketAuthorizerProvider == null ? 43 : $websocketAuthorizerProvider.hashCode());
        HeaderFilter $headerFilter = this.headerFilter;
        result = result * 59 + ($headerFilter == null ? 43 : $headerFilter.hashCode());
        QueryParameterFilter $queryParameterFilter = this.queryParameterFilter;
        result = result * 59 + ($queryParameterFilter == null ? 43 : $queryParameterFilter.hashCode());
        return result;
    }

    @Generated
    private WebsocketsModule() {
    }
}

