/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.processors;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.handler.http.HttpRequest;
import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.WebsocketMetaDataKeys;
import de.quantummaid.httpmaid.websockets.additionaldata.AdditionalWebsocketDataProvider;
import de.quantummaid.httpmaid.websockets.authorization.AuthorizationDecision;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;

public final class AddAdditionalWebsocketDataProcessor
implements Processor {
    private final AdditionalWebsocketDataProvider dataProvider;

    public static AddAdditionalWebsocketDataProcessor addAdditionalWebsocketDataProcessor(AdditionalWebsocketDataProvider dataProvider) {
        Validators.validateNotNull(dataProvider, "dataProvider");
        return new AddAdditionalWebsocketDataProcessor(dataProvider);
    }

    @Override
    public void apply(MetaData metaData) {
        metaData.getOptional(AuthorizationDecision.AUTHORIZATION_DECISION).ifPresent(authorizationDecision -> {
            if (!authorizationDecision.isAuthorized()) {
                return;
            }
            Map additionalData = metaData.getOptional(WebsocketMetaDataKeys.ADDITIONAL_WEBSOCKET_DATA).map(LinkedHashMap::new).orElseGet(LinkedHashMap::new);
            HttpRequest httpRequest = HttpRequest.httpRequest(metaData);
            Map<String, Object> providedData = this.dataProvider.provide(httpRequest);
            additionalData.putAll(providedData);
            metaData.set(WebsocketMetaDataKeys.ADDITIONAL_WEBSOCKET_DATA, additionalData);
        });
    }

    @Generated
    private AddAdditionalWebsocketDataProcessor(AdditionalWebsocketDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }
}

