/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.handler.http.files;

import de.quantummaid.httpmaid.util.Validators;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MultiformatPath {
    private final List<String> elements;

    public static MultiformatPath multiformatPath(String path) {
        Validators.validateNotNull(path, "path");
        String[] elementsArray = path.split("/");
        List<String> elementsList = Stream.of(elementsArray).filter(string -> !string.isEmpty()).collect(Collectors.toList());
        return new MultiformatPath(elementsList);
    }

    public String formatted(String prefix, String suffix) {
        return this.elements.stream().collect(Collectors.joining("/", prefix, suffix));
    }

    public String toString() {
        return "MultiformatPath(elements=" + this.elements + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultiformatPath)) {
            return false;
        }
        MultiformatPath other = (MultiformatPath)o;
        List<String> this$elements = this.elements;
        List<String> other$elements = other.elements;
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $elements = this.elements;
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        return result;
    }

    private MultiformatPath(List<String> elements) {
        this.elements = elements;
    }
}

