/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.filtermap;

import de.quantummaid.httpmaid.filtermap.FilterMap;
import de.quantummaid.httpmaid.filtermap.FilterMapEntry;
import de.quantummaid.httpmaid.util.Validators;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;

public final class FilterMapBuilder<F, T> {
    private final List<FilterMapEntry<F, T>> entries;
    private T defaultValue;

    public static <F, T> FilterMapBuilder<F, T> filterMapBuilder() {
        return new FilterMapBuilder<F, T>(new LinkedList<FilterMapEntry<F, T>>());
    }

    public void put(Predicate<F> filter, T value) {
        FilterMapEntry<F, T> entry = FilterMapEntry.filterMapEntry(filter, value);
        this.entries.add(entry);
    }

    public void setDefaultValue(T defaultValue) {
        Validators.validateNotNull(defaultValue, "defaultValue");
        this.defaultValue = defaultValue;
    }

    public FilterMap<F, T> build() {
        return FilterMap.filterMap(this.entries, this.defaultValue);
    }

    private FilterMapBuilder(List<FilterMapEntry<F, T>> entries) {
        this.entries = entries;
    }
}

