/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.processors;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.http.Headers;
import de.quantummaid.httpmaid.http.HttpRequestMethod;
import de.quantummaid.httpmaid.http.QueryParameters;
import de.quantummaid.httpmaid.http.headers.ContentType;
import de.quantummaid.httpmaid.path.Path;
import java.util.List;
import java.util.Map;

public final class TranslateToValueObjectsProcessor
implements Processor {
    public static Processor translateToValueObjectsProcessor() {
        return new TranslateToValueObjectsProcessor();
    }

    @Override
    public void apply(MetaData metaData) {
        Map<String, List<String>> rawHeaders = metaData.get(HttpMaidChainKeys.RAW_REQUEST_HEADERS);
        Headers headers = Headers.headers(rawHeaders);
        metaData.set(HttpMaidChainKeys.REQUEST_HEADERS, headers);
        ContentType contentType = ContentType.fromString(headers.getOptionalHeader("Content-Type"));
        metaData.set(HttpMaidChainKeys.REQUEST_CONTENT_TYPE, contentType);
        Map<String, String> rawQueryParameters = metaData.get(HttpMaidChainKeys.RAW_REQUEST_QUERY_PARAMETERS);
        QueryParameters queryParameters = QueryParameters.queryParameters(rawQueryParameters);
        metaData.set(HttpMaidChainKeys.QUERY_PARAMETERS, queryParameters);
        String rawMethod = metaData.get(HttpMaidChainKeys.RAW_METHOD);
        metaData.set(HttpMaidChainKeys.METHOD, HttpRequestMethod.parse(rawMethod));
        String rawPath = metaData.get(HttpMaidChainKeys.RAW_PATH);
        metaData.set(HttpMaidChainKeys.PATH, Path.path(rawPath));
    }

    public String toString() {
        return "TranslateToValueObjectsProcessor()";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof TranslateToValueObjectsProcessor;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private TranslateToValueObjectsProcessor() {
    }
}

