/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.util.Validators;

public final class MetricsProvider<T> {
    private final MetaDataKey<T> key;
    private final MetaData metaData;

    public static <T> MetricsProvider<T> metricsProvider(MetaDataKey<T> key, MetaData metaData) {
        Validators.validateNotNull(key, "key");
        Validators.validateNotNull(metaData, "metaData");
        return new MetricsProvider<T>(key, metaData);
    }

    public void provideMetric(T value) {
        Validators.validateNotNull(value, "value");
        this.metaData.set(this.key, value);
    }

    public String toString() {
        return "MetricsProvider(key=" + this.key + ", metaData=" + this.metaData + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetricsProvider)) {
            return false;
        }
        MetricsProvider other = (MetricsProvider)o;
        MetaDataKey<T> this$key = this.key;
        MetaDataKey<T> other$key = other.key;
        if (this$key == null ? other$key != null : !((Object)this$key).equals(other$key)) {
            return false;
        }
        MetaData this$metaData = this.metaData;
        MetaData other$metaData = other.metaData;
        return !(this$metaData == null ? other$metaData != null : !((Object)this$metaData).equals(other$metaData));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetaDataKey<T> $key = this.key;
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        MetaData $metaData = this.metaData;
        result = result * 59 + ($metaData == null ? 43 : ((Object)$metaData).hashCode());
        return result;
    }

    private MetricsProvider(MetaDataKey<T> key, MetaData metaData) {
        this.key = key;
        this.metaData = metaData;
    }
}

