/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.ModuleIdentifier;
import de.quantummaid.httpmaid.chains.ProcessingContext;
import de.quantummaid.httpmaid.chains.RegisteredProcessor;
import de.quantummaid.httpmaid.chains.rules.Action;
import de.quantummaid.httpmaid.chains.rules.Rule;
import de.quantummaid.httpmaid.util.Validators;
import java.util.LinkedList;
import java.util.List;

public class Chain {
    private final Action defaultAction;
    private final Action exceptionAction;
    private final List<Rule> rules;
    private final List<RegisteredProcessor> processors;
    private final ChainName name;
    private final ModuleIdentifier moduleIdentifier;

    static Chain chain(Action defaultAction, Action exceptionAction, ChainName name, ModuleIdentifier moduleIdentifier) {
        Validators.validateNotNull(defaultAction, "defaultAction");
        Validators.validateNotNull(exceptionAction, "exceptionAction");
        Validators.validateNotNull(name, "name");
        Validators.validateNotNull(moduleIdentifier, "moduleIdentifier");
        return new Chain(defaultAction, exceptionAction, new LinkedList<Rule>(), new LinkedList<RegisteredProcessor>(), name, moduleIdentifier);
    }

    void prependProcessor(RegisteredProcessor processor) {
        Validators.validateNotNull(processor, "processor");
        this.processors.add(0, processor);
    }

    void appendProcessor(RegisteredProcessor processor) {
        Validators.validateNotNull(processor, "processor");
        this.processors.add(processor);
    }

    void addRoutingRule(Rule routingRule) {
        this.rules.add(routingRule);
    }

    Action accept(ProcessingContext processingContext) {
        MetaData metaData = processingContext.metaData();
        try {
            this.processors.stream().map(RegisteredProcessor::processor).forEach(processor -> processor.apply(metaData));
            return this.rules.stream().filter(rule -> rule.matches(metaData)).findFirst().map(Rule::action).orElse(this.defaultAction);
        }
        catch (Exception e) {
            metaData.set(HttpMaidChainKeys.EXCEPTION, e);
            return this.exceptionAction;
        }
    }

    Action defaultAction() {
        return this.defaultAction;
    }

    Action exceptionAction() {
        return this.exceptionAction;
    }

    List<RegisteredProcessor> processors() {
        return this.processors;
    }

    List<Rule> rules() {
        return this.rules;
    }

    ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public ChainName getName() {
        return this.name;
    }

    private Chain(Action defaultAction, Action exceptionAction, List<Rule> rules, List<RegisteredProcessor> processors, ChainName name, ModuleIdentifier moduleIdentifier) {
        this.defaultAction = defaultAction;
        this.exceptionAction = exceptionAction;
        this.rules = rules;
        this.processors = processors;
        this.name = name;
        this.moduleIdentifier = moduleIdentifier;
    }
}

