/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains;

import de.quantummaid.httpmaid.chains.Chain;
import de.quantummaid.httpmaid.chains.ChainName;
import de.quantummaid.httpmaid.chains.ModuleIdentifier;
import de.quantummaid.httpmaid.chains.graph.Color;
import de.quantummaid.httpmaid.chains.graph.ColorPool;
import de.quantummaid.httpmaid.chains.graph.Edge;
import de.quantummaid.httpmaid.chains.graph.Graph;
import de.quantummaid.httpmaid.chains.graph.Label;
import de.quantummaid.httpmaid.chains.graph.Node;
import de.quantummaid.httpmaid.chains.rules.Action;
import de.quantummaid.httpmaid.chains.rules.Consume;
import de.quantummaid.httpmaid.chains.rules.Drop;
import de.quantummaid.httpmaid.chains.rules.Jump;
import de.quantummaid.httpmaid.chains.rules.Rule;
import de.quantummaid.httpmaid.chains.rules.RuleDescription;
import de.quantummaid.httpmaid.util.Validators;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;

final class GraphCreator {
    private static final Node CONSUME_NODE = Node.node("CONSUME", Color.GREEN);

    private GraphCreator() {
    }

    static Graph createGraph(Map<ChainName, Chain> chains, boolean withExceptionRoutes) {
        Validators.validateNotNull(chains, "chains");
        ColorPool colorPool = ColorPool.colorPool();
        HashMap nodes = new HashMap();
        chains.forEach((name, chain) -> nodes.put(name, GraphCreator.createNode(chain, colorPool)));
        LinkedList<Edge> edges = new LinkedList<Edge>();
        chains.forEach((name, chain) -> {
            Action defaultAction = chain.defaultAction();
            Color color = colorPool.assign(chain.getModuleIdentifier());
            GraphCreator.createEdge(name, defaultAction, color, Label.emptyLabel(), nodes).ifPresent(edges::add);
            chain.rules().stream().map(rule -> GraphCreator.createRuleEdge(name, rule, colorPool, nodes)).flatMap(Optional::stream).forEach(edges::add);
            if (withExceptionRoutes) {
                Action exceptionAction = chain.exceptionAction();
                GraphCreator.createEdge(name, exceptionAction, Color.RED, Label.emptyLabel(), nodes).ifPresent(edges::add);
            }
        });
        return Graph.graph(nodes.values(), edges);
    }

    private static Node createNode(Chain chain, ColorPool<ModuleIdentifier> colorPool) {
        ModuleIdentifier moduleIdentifier = chain.getModuleIdentifier();
        Color color = colorPool.assign(moduleIdentifier);
        String name = chain.getName().name();
        Label label = GraphCreator.createLabel(chain, colorPool);
        return Node.node(name, label, color);
    }

    private static Label createLabel(Chain chain, ColorPool<ModuleIdentifier> colorPool) {
        StringBuilder labelBuilder = new StringBuilder();
        Color color = colorPool.assign(chain.getModuleIdentifier());
        labelBuilder.append(color.colorized(chain.getName().name()));
        chain.processors().forEach(processor -> {
            Color processorColor = colorPool.assign(processor.identifier());
            labelBuilder.append("<br/>");
            labelBuilder.append(processorColor.colorized(processor.processor().identifier()));
        });
        return Label.htmlLabel(labelBuilder.toString());
    }

    private static Optional<Edge> createRuleEdge(ChainName from, Rule rule, ColorPool<ModuleIdentifier> colorPool, Map<ChainName, Node> nodes) {
        String label;
        Color color = colorPool.assign(rule.moduleIdentifier());
        Action action = rule.action();
        RuleDescription description = rule.description();
        if (action instanceof Jump) {
            label = color.colorized(description.value().orElse("?"));
        } else if (action instanceof Consume || action instanceof Drop) {
            label = color.colorized(description.value().orElse(""));
        } else {
            throw new UnsupportedOperationException();
        }
        return GraphCreator.createEdge(from, action, color, Label.htmlLabel(label), nodes);
    }

    private static Optional<Edge> createEdge(ChainName from, Action action, Color color, Label label, Map<ChainName, Node> nodes) {
        Node fromNode = nodes.get(from);
        if (action instanceof Jump) {
            Jump jump = (Jump)action;
            ChainName to = jump.target().orElseThrow();
            return Optional.of(Edge.edge(fromNode, nodes.get(to), color, label));
        }
        if (action instanceof Consume) {
            return Optional.of(Edge.edge(fromNode, CONSUME_NODE, color, label));
        }
        if (action instanceof Drop) {
            return Optional.empty();
        }
        throw new UnsupportedOperationException();
    }
}

