/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.processors;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.exceptions.ExceptionSerializer;
import de.quantummaid.httpmaid.util.Validators;

public final class MapExceptionProcessor
implements Processor {
    private final ExceptionSerializer exceptionSerializer;

    public static Processor mapExceptionProcessor(ExceptionSerializer responseSerializer) {
        Validators.validateNotNull(responseSerializer, "responseSerializer");
        return new MapExceptionProcessor(responseSerializer);
    }

    @Override
    public void apply(MetaData metaData) {
        Throwable exception = metaData.get(HttpMaidChainKeys.EXCEPTION);
        this.exceptionSerializer.serializeException(exception, metaData);
    }

    public String toString() {
        return "MapExceptionProcessor(exceptionSerializer=" + this.exceptionSerializer + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MapExceptionProcessor)) {
            return false;
        }
        MapExceptionProcessor other = (MapExceptionProcessor)o;
        ExceptionSerializer this$exceptionSerializer = this.exceptionSerializer;
        ExceptionSerializer other$exceptionSerializer = other.exceptionSerializer;
        return !(this$exceptionSerializer == null ? other$exceptionSerializer != null : !((Object)this$exceptionSerializer).equals(other$exceptionSerializer));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ExceptionSerializer $exceptionSerializer = this.exceptionSerializer;
        result = result * 59 + ($exceptionSerializer == null ? 43 : ((Object)$exceptionSerializer).hashCode());
        return result;
    }

    private MapExceptionProcessor(ExceptionSerializer exceptionSerializer) {
        this.exceptionSerializer = exceptionSerializer;
    }
}

