/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.util.describing;

import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.util.describing.Dimensions;

public final class TextCanvas {
    private final Dimensions dimensions;
    private final StringBuilder builder = new StringBuilder();

    static TextCanvas textCanvas(Dimensions dimensions) {
        Validators.validateNotNull(dimensions, "dimensions");
        return new TextCanvas(dimensions);
    }

    void draw(String line) {
        Validators.validateNotNullNorEmpty(line, "line");
        this.builder.append(line);
        this.builder.append("\n");
    }

    public String build() {
        return this.builder.toString();
    }

    public String toString() {
        return "TextCanvas(dimensions=" + this.dimensions + ", builder=" + this.builder + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextCanvas)) {
            return false;
        }
        TextCanvas other = (TextCanvas)o;
        Dimensions this$dimensions = this.dimensions;
        Dimensions other$dimensions = other.dimensions;
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        StringBuilder this$builder = this.builder;
        StringBuilder other$builder = other.builder;
        return !(this$builder == null ? other$builder != null : !this$builder.equals(other$builder));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Dimensions $dimensions = this.dimensions;
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        StringBuilder $builder = this.builder;
        result = result * 59 + ($builder == null ? 43 : $builder.hashCode());
        return result;
    }

    private TextCanvas(Dimensions dimensions) {
        this.dimensions = dimensions;
    }
}

