/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.cors.domain;

import java.util.Optional;

public final class MaxAge {
    private final Long maxAge;

    public static MaxAge maxAgeInSeconds(long seconds) {
        if (seconds <= 0L) {
            throw new IllegalArgumentException(String.format("seconds must be positive but was '%d'", seconds));
        }
        return new MaxAge(seconds);
    }

    public static MaxAge undefinedMaxAge() {
        return new MaxAge(null);
    }

    public Optional<String> generateHeaderValue() {
        return Optional.ofNullable(this.maxAge).map(Object::toString);
    }

    public String toString() {
        return "MaxAge(maxAge=" + this.maxAge + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaxAge)) {
            return false;
        }
        MaxAge other = (MaxAge)o;
        Long this$maxAge = this.maxAge;
        Long other$maxAge = other.maxAge;
        return !(this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $maxAge = this.maxAge;
        result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
        return result;
    }

    private MaxAge(Long maxAge) {
        this.maxAge = maxAge;
    }
}

