/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid;

import de.quantummaid.httpmaid.CoreModule;
import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.PerRouteConfigurator;
import de.quantummaid.httpmaid.chains.ChainRegistry;
import de.quantummaid.httpmaid.chains.ChainRegistryBuilder;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.chains.ConfiguratorBuilder;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.Processor;
import de.quantummaid.httpmaid.generator.builder.ConditionStage;
import de.quantummaid.httpmaid.handler.Handler;
import de.quantummaid.httpmaid.handler.http.HttpHandler;
import de.quantummaid.httpmaid.http.HttpRequestMethod;
import de.quantummaid.httpmaid.util.Validators;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;

public final class HttpMaidBuilder {
    private boolean autodetectionOfModules = true;
    private final CoreModule coreModule;
    private final List<Configurator> configurators;

    static HttpMaidBuilder httpMaidBuilder() {
        return new HttpMaidBuilder(CoreModule.coreModule(), new ArrayList<Configurator>());
    }

    public HttpMaidBuilder disableAutodectectionOfModules() {
        this.autodetectionOfModules = false;
        return this;
    }

    public HttpMaidBuilder get(String url, Object handler, PerRouteConfigurator ... perRouteConfigurators) {
        return this.serving(handler, perRouteConfigurators).forRequestPath(url).andRequestMethod(HttpRequestMethod.GET);
    }

    public HttpMaidBuilder get(String url, HttpHandler handler, PerRouteConfigurator ... perRouteConfigurators) {
        return this.get(url, (Object)handler, perRouteConfigurators);
    }

    public HttpMaidBuilder get(String url, Processor handler, PerRouteConfigurator ... perRouteConfigurators) {
        return this.get(url, handler::apply, perRouteConfigurators);
    }

    public HttpMaidBuilder post(String url, Object handler) {
        return this.serving(handler, new PerRouteConfigurator[0]).forRequestPath(url).andRequestMethod(HttpRequestMethod.POST);
    }

    public HttpMaidBuilder post(String url, HttpHandler handler) {
        return this.post(url, (Object)handler);
    }

    public HttpMaidBuilder post(String url, Consumer<MetaData> handler) {
        return this.post(url, handler::accept);
    }

    public HttpMaidBuilder put(String url, Object handler) {
        return this.serving(handler, new PerRouteConfigurator[0]).forRequestPath(url).andRequestMethod(HttpRequestMethod.PUT);
    }

    public HttpMaidBuilder put(String url, HttpHandler handler) {
        return this.put(url, (Object)handler);
    }

    public HttpMaidBuilder put(String url, Consumer<MetaData> handler) {
        return this.put(url, handler::accept);
    }

    public HttpMaidBuilder delete(String url, Object handler) {
        return this.serving(handler, new PerRouteConfigurator[0]).forRequestPath(url).andRequestMethod(HttpRequestMethod.DELETE);
    }

    public HttpMaidBuilder delete(String url, HttpHandler handler) {
        return this.delete(url, (Object)handler);
    }

    public HttpMaidBuilder delete(String url, Consumer<MetaData> handler) {
        return this.delete(url, handler::accept);
    }

    public ConditionStage<HttpMaidBuilder> serving(Handler handler) {
        return this.serving(handler, new PerRouteConfigurator[0]);
    }

    public ConditionStage<HttpMaidBuilder> serving(Object handler, PerRouteConfigurator ... perRouteConfigurators) {
        Validators.validateNotNull(handler, "handler");
        return condition -> {
            this.coreModule.registerHandler(condition, handler, Arrays.asList(perRouteConfigurators));
            return this;
        };
    }

    public HttpMaidBuilder configured(ConfiguratorBuilder configuratorBuilder) {
        Validators.validateNotNull(configuratorBuilder, "configuratorBuilder");
        Configurator configurator = configuratorBuilder.build();
        return this.configured(configurator);
    }

    public HttpMaidBuilder configured(Configurator configurator) {
        Validators.validateNotNull(configurator, "configurator");
        this.configurators.add(configurator);
        return this;
    }

    public HttpMaid build() {
        Instant begin = Instant.now();
        ChainRegistryBuilder chainRegistryBuilder = ChainRegistryBuilder.chainRegistryBuilder();
        chainRegistryBuilder.addModule(this.coreModule);
        if (this.autodetectionOfModules) {
            chainRegistryBuilder.addModuleIfPresent("de.quantummaid.httpmaid.events.EventModule");
            chainRegistryBuilder.addModuleIfPresent("de.quantummaid.httpmaid.usecases.UseCasesModule");
            chainRegistryBuilder.addModuleIfPresent("de.quantummaid.httpmaid.mapmaid.MapMaidModule");
        }
        this.configurators.forEach(chainRegistryBuilder::addConfigurator);
        ChainRegistry chainRegistry = chainRegistryBuilder.build();
        HttpMaid httpMaid = HttpMaid.httpMaid(chainRegistry);
        Instant end = Instant.now();
        Duration startUpTime = Duration.between(begin, end);
        chainRegistry.addMetaDatum(HttpMaid.STARTUP_TIME, startUpTime);
        return httpMaid;
    }

    public String toString() {
        return "HttpMaidBuilder(autodetectionOfModules=" + this.autodetectionOfModules + ", coreModule=" + this.coreModule + ", configurators=" + this.configurators + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpMaidBuilder)) {
            return false;
        }
        HttpMaidBuilder other = (HttpMaidBuilder)o;
        if (this.autodetectionOfModules != other.autodetectionOfModules) {
            return false;
        }
        CoreModule this$coreModule = this.coreModule;
        CoreModule other$coreModule = other.coreModule;
        if (this$coreModule == null ? other$coreModule != null : !((Object)this$coreModule).equals(other$coreModule)) {
            return false;
        }
        List<Configurator> this$configurators = this.configurators;
        List<Configurator> other$configurators = other.configurators;
        return !(this$configurators == null ? other$configurators != null : !((Object)this$configurators).equals(other$configurators));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.autodetectionOfModules ? 79 : 97);
        CoreModule $coreModule = this.coreModule;
        result = result * 59 + ($coreModule == null ? 43 : ((Object)$coreModule).hashCode());
        List<Configurator> $configurators = this.configurators;
        result = result * 59 + ($configurators == null ? 43 : ((Object)$configurators).hashCode());
        return result;
    }

    private HttpMaidBuilder(CoreModule coreModule, List<Configurator> configurators) {
        this.coreModule = coreModule;
        this.configurators = configurators;
    }
}

