/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.path;

import de.quantummaid.httpmaid.path.AnyMatcher;
import de.quantummaid.httpmaid.path.CaptureMatcher;
import de.quantummaid.httpmaid.path.Path;
import de.quantummaid.httpmaid.path.RegexMatcher;
import de.quantummaid.httpmaid.path.StaticMatcher;
import de.quantummaid.httpmaid.path.statemachine.ElementPosition;
import de.quantummaid.httpmaid.path.statemachine.MatchingResult;
import de.quantummaid.httpmaid.path.statemachine.State;
import de.quantummaid.httpmaid.path.statemachine.StateMachine;
import de.quantummaid.httpmaid.path.statemachine.StateMachineBuilder;
import de.quantummaid.httpmaid.path.statemachine.StateMachineMatcher;
import de.quantummaid.httpmaid.path.statemachine.Transition;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class PathTemplate {
    private final List<String> elements;
    private final StateMachine<String> stateMachine;
    private final List<String> parameters;

    public static PathTemplate pathTemplate(String asString) {
        List<String> elementsAsStrings = PathTemplate.splitIntoElements(asString);
        List matchers = elementsAsStrings.stream().map(PathTemplate::elementFromStringSpecification).collect(Collectors.toList());
        StateMachineBuilder stateMachineBuilder = StateMachineBuilder.stateMachineBuilder();
        State currentState = stateMachineBuilder.createState();
        for (StateMachineMatcher matcher : matchers) {
            if (matcher instanceof AnyMatcher) {
                stateMachineBuilder.addTransition(currentState, Transition.transition(matcher, currentState));
                continue;
            }
            State nextState = stateMachineBuilder.createState();
            stateMachineBuilder.addTransition(currentState, Transition.transition(matcher, nextState));
            currentState = nextState;
        }
        stateMachineBuilder.markAsFinal(currentState);
        StateMachine<String> stateMachine = stateMachineBuilder.build();
        List<String> parameters = matchers.stream().map(StateMachineMatcher::captures).flatMap(Collection::stream).collect(Collectors.toList());
        return new PathTemplate(elementsAsStrings, stateMachine, parameters);
    }

    public boolean matches(Path path) {
        return this.match(path).isSuccessful();
    }

    public List<String> parameters() {
        return this.parameters;
    }

    public Map<String, String> extractPathParameters(Path path) {
        return this.match(path).captures();
    }

    private MatchingResult match(Path path) {
        String raw = path.raw();
        List<String> elementsAsStrings = PathTemplate.splitIntoElements(raw);
        ElementPosition<String> inputPosition = ElementPosition.start(elementsAsStrings);
        return this.stateMachine.accept(inputPosition);
    }

    public String toString() {
        return this.elements.stream().collect(Collectors.joining("/", "/", ""));
    }

    private static StateMachineMatcher<String> elementFromStringSpecification(String stringSpecification) {
        if (AnyMatcher.isRecursiveWildcard(stringSpecification)) {
            return AnyMatcher.anyMatcher();
        }
        if (CaptureMatcher.isWildcard(stringSpecification)) {
            return CaptureMatcher.fromStringSpecification(stringSpecification);
        }
        if (RegexMatcher.isRegex(stringSpecification)) {
            return RegexMatcher.fromStringSpecification(stringSpecification);
        }
        return StaticMatcher.fromStringSpecification(stringSpecification);
    }

    private static List<String> splitIntoElements(String pathAsString) {
        return Arrays.stream(pathAsString.split("/")).filter(string -> !string.isEmpty()).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PathTemplate)) {
            return false;
        }
        PathTemplate other = (PathTemplate)o;
        List<String> this$elements = this.elements;
        List<String> other$elements = other.elements;
        if (this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements)) {
            return false;
        }
        StateMachine<String> this$stateMachine = this.stateMachine;
        StateMachine<String> other$stateMachine = other.stateMachine;
        if (this$stateMachine == null ? other$stateMachine != null : !((Object)this$stateMachine).equals(other$stateMachine)) {
            return false;
        }
        List<String> this$parameters = this.parameters;
        List<String> other$parameters = other.parameters;
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $elements = this.elements;
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        StateMachine<String> $stateMachine = this.stateMachine;
        result = result * 59 + ($stateMachine == null ? 43 : ((Object)$stateMachine).hashCode());
        List<String> $parameters = this.parameters;
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    private PathTemplate(List<String> elements, StateMachine<String> stateMachine, List<String> parameters) {
        this.elements = elements;
        this.stateMachine = stateMachine;
        this.parameters = parameters;
    }
}

