/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.path.statemachine;

import de.quantummaid.httpmaid.path.statemachine.State;
import de.quantummaid.httpmaid.path.statemachine.SuccessfulTransition;
import de.quantummaid.httpmaid.path.statemachine.Transition;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

final class TransitionFunction<T> {
    private final Map<State, List<Transition<T>>> transitions;

    static <T> TransitionFunction<T> transitionFunction(Map<State, List<Transition<T>>> transitions) {
        return new TransitionFunction<T>(transitions);
    }

    List<SuccessfulTransition> transition(State from, T input) {
        List transitionsOfState = this.transitions.getOrDefault(from, Collections.emptyList());
        return transitionsOfState.stream().map(transistion -> transistion.transition(input)).filter(Optional::isPresent).map(Optional::get).sorted(Collections.reverseOrder(Comparator.comparingInt(transition -> transition.nextState().number()))).collect(Collectors.toList());
    }

    public String toString() {
        return "TransitionFunction(transitions=" + this.transitions + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransitionFunction)) {
            return false;
        }
        TransitionFunction other = (TransitionFunction)o;
        Map<State, List<Transition<T>>> this$transitions = this.transitions;
        Map<State, List<Transition<T>>> other$transitions = other.transitions;
        return !(this$transitions == null ? other$transitions != null : !((Object)this$transitions).equals(other$transitions));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<State, List<Transition<T>>> $transitions = this.transitions;
        result = result * 59 + ($transitions == null ? 43 : ((Object)$transitions).hashCode());
        return result;
    }

    private TransitionFunction(Map<State, List<Transition<T>>> transitions) {
        this.transitions = transitions;
    }
}

