/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.path.statemachine;

import de.quantummaid.httpmaid.path.statemachine.ElementPosition;
import de.quantummaid.httpmaid.path.statemachine.MatchingResult;
import de.quantummaid.httpmaid.path.statemachine.State;
import de.quantummaid.httpmaid.path.statemachine.SuccessfulTransition;
import de.quantummaid.httpmaid.path.statemachine.TransitionFunction;
import de.quantummaid.httpmaid.util.Validators;
import java.util.List;

public final class StateMachine<T> {
    private final State initialState;
    private final TransitionFunction<T> transitionFunction;
    private final List<State> finalStates;

    static <T> StateMachine<T> stateMachine(State initialState, TransitionFunction<T> transitionFunction, List<State> finalStates) {
        Validators.validateNotNull(initialState, "initialState");
        Validators.validateNotNull(transitionFunction, "transitionFunction");
        Validators.validateNotNull(finalStates, "finalStates");
        return new StateMachine<T>(initialState, transitionFunction, finalStates);
    }

    public MatchingResult accept(ElementPosition<T> elementPosition) {
        return this.accept(this.initialState, elementPosition);
    }

    private MatchingResult accept(State state, ElementPosition<T> elementPosition) {
        if (elementPosition.isEnd()) {
            return MatchingResult.matchingResult(this.finalStates.contains(state));
        }
        T element = elementPosition.get();
        List<SuccessfulTransition> successfulTransitions = this.transitionFunction.transition(state, element);
        ElementPosition<T> nextPosition = elementPosition.next();
        for (SuccessfulTransition successfulTransition : successfulTransitions) {
            State nextState = successfulTransition.nextState();
            MatchingResult result = this.accept(nextState, nextPosition);
            if (!result.isSuccessful()) continue;
            return result.merge(successfulTransition.captures());
        }
        return MatchingResult.fail();
    }

    public String toString() {
        return "StateMachine(initialState=" + this.initialState + ", transitionFunction=" + this.transitionFunction + ", finalStates=" + this.finalStates + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StateMachine)) {
            return false;
        }
        StateMachine other = (StateMachine)o;
        State this$initialState = this.initialState;
        State other$initialState = other.initialState;
        if (this$initialState == null ? other$initialState != null : !((Object)this$initialState).equals(other$initialState)) {
            return false;
        }
        TransitionFunction<T> this$transitionFunction = this.transitionFunction;
        TransitionFunction<T> other$transitionFunction = other.transitionFunction;
        if (this$transitionFunction == null ? other$transitionFunction != null : !((Object)this$transitionFunction).equals(other$transitionFunction)) {
            return false;
        }
        List<State> this$finalStates = this.finalStates;
        List<State> other$finalStates = other.finalStates;
        return !(this$finalStates == null ? other$finalStates != null : !((Object)this$finalStates).equals(other$finalStates));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        State $initialState = this.initialState;
        result = result * 59 + ($initialState == null ? 43 : ((Object)$initialState).hashCode());
        TransitionFunction<T> $transitionFunction = this.transitionFunction;
        result = result * 59 + ($transitionFunction == null ? 43 : ((Object)$transitionFunction).hashCode());
        List<State> $finalStates = this.finalStates;
        result = result * 59 + ($finalStates == null ? 43 : ((Object)$finalStates).hashCode());
        return result;
    }

    private StateMachine(State initialState, TransitionFunction<T> transitionFunction, List<State> finalStates) {
        this.initialState = initialState;
        this.transitionFunction = transitionFunction;
        this.finalStates = finalStates;
    }
}

