/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.purejavaendpoint;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.util.Streams;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class PureJavaEndpointHandler
implements HttpHandler {
    private final HttpMaid httpMaid;

    static HttpHandler javaOnlyEndpointHandler(HttpMaid httpMaid) {
        return new PureJavaEndpointHandler(httpMaid);
    }

    @Override
    public void handle(HttpExchange httpExchange) {
        String requestMethod = httpExchange.getRequestMethod();
        String path = httpExchange.getRequestURI().getPath();
        String query = httpExchange.getRequestURI().getQuery();
        Map<String, String> queryParameters = PureJavaEndpointHandler.queryToMap(query);
        Headers headers = httpExchange.getRequestHeaders();
        InputStream body = httpExchange.getRequestBody();
        MetaData metaData = MetaData.emptyMetaData();
        metaData.set(HttpMaidChainKeys.RAW_REQUEST_HEADERS, headers);
        metaData.set(HttpMaidChainKeys.RAW_REQUEST_QUERY_PARAMETERS, queryParameters);
        metaData.set(HttpMaidChainKeys.RAW_METHOD, requestMethod);
        metaData.set(HttpMaidChainKeys.RAW_PATH, path);
        metaData.set(HttpMaidChainKeys.REQUEST_BODY_STREAM, body);
        metaData.set(HttpMaidChainKeys.IS_HTTP_REQUEST, true);
        this.httpMaid.handleRequest(metaData, httpResponse -> {
            Map<String, String> responseHeaders = metaData.get(HttpMaidChainKeys.RESPONSE_HEADERS);
            responseHeaders.forEach((key, value) -> httpExchange.getResponseHeaders().put((String)key, Collections.singletonList(value)));
            int responseStatus = metaData.get(HttpMaidChainKeys.RESPONSE_STATUS);
            httpExchange.sendResponseHeaders(responseStatus, 0L);
            OutputStream outputStream = httpExchange.getResponseBody();
            InputStream responseBody = metaData.getOptional(HttpMaidChainKeys.RESPONSE_STREAM).orElseGet(() -> Streams.stringToInputStream(""));
            Streams.streamInputStreamToOutputStream(responseBody, outputStream);
        });
    }

    private static Map<String, String> queryToMap(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (query == null) {
            return result;
        }
        for (String param : query.split("&")) {
            String[] entry = param.split("=");
            if (entry.length > 1) {
                result.put(entry[0], entry[1]);
                continue;
            }
            result.put(entry[0], "");
        }
        return result;
    }

    private PureJavaEndpointHandler(HttpMaid httpMaid) {
        this.httpMaid = httpMaid;
    }
}

