/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains.rules;

import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.ModuleIdentifier;
import de.quantummaid.httpmaid.chains.rules.Action;
import de.quantummaid.httpmaid.chains.rules.RuleDescription;
import de.quantummaid.httpmaid.util.Validators;
import java.util.function.Predicate;

public final class Rule {
    private final ModuleIdentifier moduleIdentifier;
    private final Predicate<MetaData> matcher;
    private final Action action;
    private final RuleDescription ruleDescription;

    public static Rule rule(ModuleIdentifier moduleIdentifier, Predicate<MetaData> matcher, Action action, RuleDescription ruleDescription) {
        Validators.validateNotNull(moduleIdentifier, "moduleIdentifier");
        Validators.validateNotNull(matcher, "matcher");
        Validators.validateNotNull(action, "action");
        Validators.validateNotNull(ruleDescription, "ruleDescription");
        return new Rule(moduleIdentifier, matcher, action, ruleDescription);
    }

    public boolean matches(MetaData metaData) {
        return this.matcher.test(metaData);
    }

    public Action action() {
        return this.action;
    }

    public ModuleIdentifier moduleIdentifier() {
        return this.moduleIdentifier;
    }

    public RuleDescription description() {
        return this.ruleDescription;
    }

    public String toString() {
        return "Rule(moduleIdentifier=" + this.moduleIdentifier + ", matcher=" + this.matcher + ", action=" + this.action + ", ruleDescription=" + this.ruleDescription + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)o;
        ModuleIdentifier this$moduleIdentifier = this.moduleIdentifier;
        ModuleIdentifier other$moduleIdentifier = other.moduleIdentifier;
        if (this$moduleIdentifier == null ? other$moduleIdentifier != null : !((Object)this$moduleIdentifier).equals(other$moduleIdentifier)) {
            return false;
        }
        Predicate<MetaData> this$matcher = this.matcher;
        Predicate<MetaData> other$matcher = other.matcher;
        if (this$matcher == null ? other$matcher != null : !this$matcher.equals(other$matcher)) {
            return false;
        }
        Action this$action = this.action;
        Action other$action = other.action;
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        RuleDescription this$ruleDescription = this.ruleDescription;
        RuleDescription other$ruleDescription = other.ruleDescription;
        return !(this$ruleDescription == null ? other$ruleDescription != null : !((Object)this$ruleDescription).equals(other$ruleDescription));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ModuleIdentifier $moduleIdentifier = this.moduleIdentifier;
        result = result * 59 + ($moduleIdentifier == null ? 43 : ((Object)$moduleIdentifier).hashCode());
        Predicate<MetaData> $matcher = this.matcher;
        result = result * 59 + ($matcher == null ? 43 : $matcher.hashCode());
        Action $action = this.action;
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        RuleDescription $ruleDescription = this.ruleDescription;
        result = result * 59 + ($ruleDescription == null ? 43 : ((Object)$ruleDescription).hashCode());
        return result;
    }

    private Rule(ModuleIdentifier moduleIdentifier, Predicate<MetaData> matcher, Action action, RuleDescription ruleDescription) {
        this.moduleIdentifier = moduleIdentifier;
        this.matcher = matcher;
        this.action = action;
        this.ruleDescription = ruleDescription;
    }
}

