/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.util;

import de.quantummaid.httpmaid.util.Validators;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

public final class Streams {
    private static final int BUFFER_SIZE = 1024;

    private Streams() {
    }

    public static InputStream stringToInputStream(String string) {
        return new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8));
    }

    public static String inputStreamToString(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8).useDelimiter("\\A");
        if (scanner.hasNext()) {
            return scanner.next();
        }
        return "";
    }

    public static void streamInputStreamToOutputStream(InputStream inputStream, OutputStream outputStream) {
        try {
            int length;
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            inputStream.close();
            outputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void consumeInputStream(InputStream inputStream, IOConsumer<ByteBuffer> chunkConsumer) {
        Validators.validateNotNull(inputStream, "inputStream");
        Validators.validateNotNull(chunkConsumer, "chunkConsumer");
        int bufferSize = 0x100000;
        byte[] buffer = new byte[0x100000];
        try (InputStream inputStream2 = inputStream;){
            while (true) {
                int bytesRead;
                if ((bytesRead = inputStream.read(buffer, 0, 0x100000)) == -1) {
                    return;
                }
                ByteBuffer chunk = ByteBuffer.wrap(buffer, 0, bytesRead);
                chunkConsumer.accept(chunk);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @FunctionalInterface
    public static interface IOConsumer<T> {
        public void accept(T var1) throws IOException;
    }
}

