/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.chains;

import de.quantummaid.httpmaid.chains.ChainModule;
import de.quantummaid.httpmaid.chains.ChainRegistry;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.chains.autoloading.Autoloader;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class ChainRegistryBuilder {
    private final List<ChainModule> modules;
    private final List<Configurator> configurators;

    public static ChainRegistryBuilder chainRegistryBuilder() {
        return new ChainRegistryBuilder(new LinkedList<ChainModule>(), new LinkedList<Configurator>());
    }

    public void addModule(ChainModule module) {
        Validators.validateNotNull(module, "module");
        this.modules.add(module);
    }

    public void addModuleIfPresent(String fullyQualifiedClassName) {
        Validators.validateNotNullNorEmpty(fullyQualifiedClassName, "fullyQualifiedClassName");
        Autoloader.loadModule(fullyQualifiedClassName).ifPresent(this::addModule);
    }

    public void addConfigurator(Configurator configurator) {
        Validators.validateNotNull(configurator, "configurator");
        this.configurators.add(configurator);
    }

    public ChainRegistry build() {
        MetaData metaData = MetaData.emptyMetaData();
        DependencyRegistry dependencyRegistry = DependencyRegistry.load(this.modules, metaData);
        ChainRegistryBuilder.enterDefaultDependencies(this.modules, dependencyRegistry);
        ChainRegistryBuilder.enterDefaultDependencies(this.configurators, dependencyRegistry);
        dependencyRegistry.modules().stream().forEach(module -> module.init(metaData));
        this.configurators.forEach(configurator -> configurator.init(metaData));
        this.configurators.forEach(configurator -> configurator.configure(dependencyRegistry));
        dependencyRegistry.modules().stream().forEach(module -> module.configure(dependencyRegistry));
        return dependencyRegistry.buildChainRegistry();
    }

    private static void enterDefaultDependencies(List<? extends Configurator> configurators, DependencyRegistry dependencyRegistry) {
        configurators.stream().map(Configurator::supplyModulesIfNotAlreadyPresent).flatMap(Collection::stream).forEach(module -> ChainRegistryBuilder.enterDefaultDependency(module, dependencyRegistry));
    }

    private static void enterDefaultDependency(ChainModule dependency, DependencyRegistry dependencyRegistry) {
        List<ChainModule> followUpDependencies = dependencyRegistry.addIfNotAlreadyPresentAndReturnFollowUpDependencies(dependency);
        followUpDependencies.forEach(module -> ChainRegistryBuilder.enterDefaultDependency(module, dependencyRegistry));
    }

    public String toString() {
        return "ChainRegistryBuilder(modules=" + this.modules + ", configurators=" + this.configurators + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChainRegistryBuilder)) {
            return false;
        }
        ChainRegistryBuilder other = (ChainRegistryBuilder)o;
        List<ChainModule> this$modules = this.modules;
        List<ChainModule> other$modules = other.modules;
        if (this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules)) {
            return false;
        }
        List<Configurator> this$configurators = this.configurators;
        List<Configurator> other$configurators = other.configurators;
        return !(this$configurators == null ? other$configurators != null : !((Object)this$configurators).equals(other$configurators));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ChainModule> $modules = this.modules;
        result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
        List<Configurator> $configurators = this.configurators;
        result = result * 59 + ($configurators == null ? 43 : ((Object)$configurators).hashCode());
        return result;
    }

    private ChainRegistryBuilder(List<ChainModule> modules, List<Configurator> configurators) {
        this.modules = modules;
        this.configurators = configurators;
    }
}

