/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.cors.domain;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.http.HttpRequestMethod;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class RequestedMethod {
    private static final List<HttpRequestMethod> SIMPLE_METHODS = Arrays.asList(HttpRequestMethod.GET, HttpRequestMethod.POST, HttpRequestMethod.HEAD);
    private final HttpRequestMethod method;

    public static RequestedMethod load(MetaData metaData) {
        Validators.validateNotNull(metaData, "metaData");
        String method = metaData.get(HttpMaidChainKeys.REQUEST_HEADERS).getOptionalHeader("Access-Control-Request-Method").orElseThrow();
        Validators.validateNotNullNorEmpty(method, "method");
        return new RequestedMethod(HttpRequestMethod.parse(method));
    }

    public boolean isSimpleMethod() {
        return SIMPLE_METHODS.contains(this.method);
    }

    public String internalValueForMapping() {
        return this.method.name();
    }

    public boolean matches(HttpRequestMethod method) {
        Validators.validateNotNull(method, "method");
        return Objects.equals(method, this.method);
    }

    public String toString() {
        return "RequestedMethod(method=" + this.method + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestedMethod)) {
            return false;
        }
        RequestedMethod other = (RequestedMethod)o;
        HttpRequestMethod this$method = this.method;
        HttpRequestMethod other$method = other.method;
        return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        HttpRequestMethod $method = this.method;
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        return result;
    }

    private RequestedMethod(HttpRequestMethod method) {
        this.method = method;
    }
}

