/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.marshalling.urlencoded;

import de.quantummaid.httpmaid.marshalling.urlencoded.KeyElement;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

final class Key {
    private final List<KeyElement> parts;

    static Key emptyKey() {
        return new Key(new LinkedList<KeyElement>());
    }

    static Key parseKey(String string) {
        Validators.validateNotNull(string, "string");
        if (!string.contains("[")) {
            return new Key(Collections.singletonList(KeyElement.keyElement(string)));
        }
        String head = string.substring(0, string.indexOf("["));
        String tail = string.substring(string.indexOf("[") + 1, string.length() - 1);
        String[] tailElements = tail.split("]\\[");
        LinkedList<KeyElement> elements = new LinkedList<KeyElement>();
        elements.add(KeyElement.keyElement(head));
        Arrays.stream(tailElements).map(KeyElement::keyElement).forEach(elements::add);
        return new Key(elements);
    }

    boolean isPrefixTo(Key candidate) {
        if (this.parts.size() > candidate.parts.size()) {
            return false;
        }
        for (int i = 0; i < this.parts.size(); ++i) {
            if (this.parts.get(i).equals(candidate.parts.get(i))) continue;
            return false;
        }
        return true;
    }

    KeyElement elementAfter(Key prefix) {
        if (!prefix.isPrefixTo(this)) {
            throw new IllegalArgumentException();
        }
        int index = prefix.parts.size();
        if (index >= this.parts.size()) {
            throw new IllegalArgumentException();
        }
        return this.parts.get(index);
    }

    Key child(String element) {
        return this.child(KeyElement.keyElement(element));
    }

    Key child(KeyElement element) {
        Validators.validateNotNull(element, "element");
        LinkedList<KeyElement> newParts = new LinkedList<KeyElement>(this.parts);
        newParts.add(element);
        return new Key(newParts);
    }

    String render() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.parts.size(); ++i) {
            KeyElement element = this.parts.get(i);
            String rendered = i == 0 ? element.renderAsFirstElement() : element.renderAsIndexElement();
            builder.append(rendered);
        }
        return builder.toString();
    }

    public String toString() {
        return "Key(parts=" + this.parts + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key other = (Key)o;
        List<KeyElement> this$parts = this.parts;
        List<KeyElement> other$parts = other.parts;
        return !(this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<KeyElement> $parts = this.parts;
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        return result;
    }

    private Key(List<KeyElement> parts) {
        this.parts = parts;
    }
}

