/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.cors.domain;

import de.quantummaid.httpmaid.HttpMaidChainKeys;
import de.quantummaid.httpmaid.chains.MetaData;
import de.quantummaid.httpmaid.cors.domain.RequestedHeader;
import de.quantummaid.httpmaid.util.Validators;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class RequestedHeaders {
    private final List<RequestedHeader> headers;

    public static RequestedHeaders load(MetaData metaData) {
        Validators.validateNotNull(metaData, "metaData");
        String commaSeparatedHeaders = metaData.get(HttpMaidChainKeys.REQUEST_HEADERS).getOptionalHeader("Access-Control-Request-Headers").orElse("");
        Validators.validateNotNull(commaSeparatedHeaders, "commaSeparatedHeaders");
        List<RequestedHeader> headers = Arrays.stream(commaSeparatedHeaders.split(",")).filter(s -> !s.isEmpty()).map(RequestedHeader::requestedHeader).collect(Collectors.toList());
        return new RequestedHeaders(headers);
    }

    public Optional<String> generateHeaderValue() {
        if (this.hasOnlySimpleHeaders()) {
            return Optional.empty();
        }
        return Optional.of(this.headers.stream().filter(header -> !header.isSimpleHeader()).map(RequestedHeader::internalValueForMapping).collect(Collectors.joining(",")));
    }

    private boolean hasOnlySimpleHeaders() {
        for (RequestedHeader header : this.headers) {
            if (header.isSimpleHeader()) continue;
            return false;
        }
        return true;
    }

    public List<RequestedHeader> headers() {
        return this.headers;
    }

    public String toString() {
        return "RequestedHeaders(headers=" + this.headers + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestedHeaders)) {
            return false;
        }
        RequestedHeaders other = (RequestedHeaders)o;
        List<RequestedHeader> this$headers = this.headers;
        List<RequestedHeader> other$headers = other.headers;
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<RequestedHeader> $headers = this.headers;
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    private RequestedHeaders(List<RequestedHeader> headers) {
        this.headers = headers;
    }
}

