/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.handler.distribution;

import de.quantummaid.httpmaid.chains.DependencyRegistry;
import de.quantummaid.httpmaid.chains.MetaDataKey;
import de.quantummaid.httpmaid.handler.distribution.DistributableHandler;
import de.quantummaid.httpmaid.handler.distribution.DistributerAndFollowUps;
import de.quantummaid.httpmaid.handler.distribution.HandlerDistributor;
import de.quantummaid.httpmaid.handler.distribution.HandlerDistributorException;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public final class HandlerDistributors {
    public static final MetaDataKey<HandlerDistributors> HANDLER_DISTRIBUTORS = MetaDataKey.metaDataKey("HANDLER_DISTRIBUTORS");
    private final List<HandlerDistributor> distributors;

    public static HandlerDistributors handlerDistributors() {
        return new HandlerDistributors(new LinkedList<HandlerDistributor>());
    }

    public void register(Predicate<DistributableHandler> predicate, DistributerAndFollowUps handlerConsumer) {
        HandlerDistributor handlerDistributor = HandlerDistributor.handlerDistributor(predicate, handlerConsumer);
        this.distributors.add(handlerDistributor);
    }

    public void distribute(DistributableHandler handler, DependencyRegistry dependencyRegistry) {
        handler.perRouteConfigurators().forEach(perRouteConfigurator -> perRouteConfigurator.configure(handler.condition(), handler.handler(), dependencyRegistry));
        Optional<HandlerDistributor> match = this.distributors.stream().filter(handlerDistributor -> handlerDistributor.appliesTo(handler)).findFirst();
        if (match.isEmpty()) {
            throw HandlerDistributorException.handlerDistributorException(handler);
        }
        HandlerDistributor handlerDistributor2 = match.get();
        List<DistributableHandler> followUps = handlerDistributor2.distributeAndProvideFollowUps(handler);
        followUps.forEach(followUp -> this.distribute((DistributableHandler)followUp, dependencyRegistry));
    }

    public String toString() {
        return "HandlerDistributors(distributors=" + this.distributors + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HandlerDistributors)) {
            return false;
        }
        HandlerDistributors other = (HandlerDistributors)o;
        List<HandlerDistributor> this$distributors = this.distributors;
        List<HandlerDistributor> other$distributors = other.distributors;
        return !(this$distributors == null ? other$distributors != null : !((Object)this$distributors).equals(other$distributors));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<HandlerDistributor> $distributors = this.distributors;
        result = result * 59 + ($distributors == null ? 43 : ((Object)$distributors).hashCode());
        return result;
    }

    private HandlerDistributors(List<HandlerDistributor> distributors) {
        this.distributors = distributors;
    }
}

